window.onload = function() {
	var host = window.location.protocol.concat("//").concat(window.location.host);
	var application = host.concat("/").concat(window.location.pathname.split("/")[1]);
	var url = application + "/api/openapi.json";
	
	const ui = SwaggerUIBundle({
        url: url,
        dom_id: '#swagger-ui-container',
        docExpansion: 'none',
        defaultModelsExpandDepth: -1,
        deepLinking: true,
        presets: [
          SwaggerUIBundle.presets.apis,
          SwaggerUIStandalonePreset
        ],
        plugins: [
          SwaggerUIBundle.plugins.DownloadUrl
        ],
        layout: "StandaloneLayout",
        apisSorter: "alpha",
        tagsSorter: "alpha",
        operationsSorter: "alpha",
        
        validatorUrl: null
      });

      window.ui = ui;
}