package de.narimo.georepo.server.api;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;

import de.narimo.commons.dto.User;
import de.narimo.geocore.ws.repository.UserRepository;
import de.narimo.georepo.server.repository.AppDetails;
import de.narimo.georepo.server.repository.AppKey;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;

@Provider
@Path("/apps")
@Tag(name = "AppSettings")
public class AppController {

    AppSettingsService settingsService = new AppSettingsService();

    @GET
    @Path("/")
    @Produces({ MediaType.APPLICATION_JSON })
    @Operation(summary = "Get my appkeys")
    public Response getAppKeys(
            @Context SecurityContext sec) throws IOException, SQLException {

        String username = sec.getUserPrincipal().getName();
        User user = UserRepository.getUser(username).get();

        try {
            List<AppKey> appkeys = settingsService.getAppKeys(user);
            return Response.ok().entity(appkeys).build();
        } catch (Exception e) {
            e.printStackTrace();
            return Response.status(Status.BAD_REQUEST).build();
        }
    }

    @GET
    @Path("/{appkey}/details")
    @Produces({ MediaType.APPLICATION_JSON })
    @Operation(summary = "Get appdetails")
    public Response getAppDetails(
            @PathParam("appkey") String appkey) throws IOException, SQLException {

        try {
            List<AppDetails> appdetails = settingsService.getAppDetails(appkey);
            return Response.ok().entity(appdetails).build();
        } catch (Exception e) {
            e.printStackTrace();
            return Response.status(Status.BAD_REQUEST).build();
        }
    }

    @POST
    @Path("/")
    @Produces({ MediaType.APPLICATION_JSON })
    @Operation(summary = "Create a new appkey")
    public Response createAppKey(
            @Context SecurityContext sec,
            @QueryParam("organisation") String organisation,
            @QueryParam("ownername") String ownerName,
            @QueryParam("addressStreet") String addressStreet,
            @QueryParam("addressStreetnumber") String addressStreetnumber,
            @QueryParam("addressPostcode") String addressPostcode,
            @QueryParam("addressCity") String addressCity,
            @QueryParam("templateKey") String templateKey) throws IOException, SQLException {

        String username = sec.getUserPrincipal().getName();
        User user = UserRepository.getUser(username).get();

        try {
            AppKey appkey = new AppKey();
            appkey.setTemplateKey(templateKey);
            appkey.setOrganisation(organisation);
            appkey.setOwnerName(ownerName);
            appkey.setAddressCity(addressCity);
            appkey.setAddressPostcode(addressPostcode);
            appkey.setAddressStreet(addressStreet);
            appkey.setAddressStreetnumber(addressStreetnumber);

            String key = settingsService.createAppKey(user, appkey);

            AppKey createdAppKey = new AppKey();
            createdAppKey.setAppKey(key);

            return Response.ok().entity(createdAppKey).build();
        } catch (NotFoundException e) {
            e.printStackTrace();
            return Response.status(Status.BAD_REQUEST).entity("Template key is invalid.")
                    .type(MediaType.TEXT_PLAIN).build();
        }
    }
}
