package de.narimo.georepo.server.api;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;

import de.narimo.georepo.server.repository.DatasetRepository;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;

@Provider
@Path("/workspaces/{workspace}/layers/{layername}/features/{gfid}/tags")
@Tag(name = "Tags")
public class TagsController {

    TagService tagService = new TagService();

    @POST
    @Path("/")
    @Consumes({ MediaType.APPLICATION_JSON })
    @Operation(summary = "Add tags")
    public Response addFeatureTags(
            @Context SecurityContext sec,
            @PathParam("workspace") String workspace,
            @PathParam("layername") String dataLayerName,
            @PathParam("gfid") int gfid,
            List<String> tags)
            throws IOException, SQLException {

        try {
            int layerId = DatasetRepository.getLayerId(workspace, dataLayerName);
            tagService.addTags(layerId, gfid, tags);
            return Response.ok().build();
        } catch (SQLException e) {
            e.printStackTrace();
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Path("/")
    @Consumes({ MediaType.APPLICATION_JSON })
    @Operation(summary = "Remove tags")
    public Response removeFeatureTags(
            @Context SecurityContext sec,
            @PathParam("workspace") String workspace,
            @PathParam("layername") String dataLayerName,
            @PathParam("gfid") int gfid,
            List<String> tags)
            throws IOException, SQLException {

        try {
            int layerId = DatasetRepository.getLayerId(workspace, dataLayerName);
            tagService.removeTags(layerId, gfid, tags);
            return Response.ok().build();
        } catch (SQLException e) {
            e.printStackTrace();
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}