package de.narimo.georepo.server.http;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

import de.narimo.commons.http.URLResponse;
import de.narimo.commons.ws.http.HTTPProxy;
import de.narimo.commons.ws.http.HttpMethod;
import de.narimo.commons.ws.http.HttpURLClient;

public class GeoserverHTTPProxy extends HTTPProxy{

	public static Response pipe(
			String to,
			UriInfo uriinfo,
			HttpHeaders httpHeaders,
			byte[] body,
			HttpMethod method
			) throws Exception{
		
		MultivaluedMap<String, String> queryParams = uriinfo.getQueryParameters();
		Map<String, String> queryParamsSimple = new HashMap<String, String>();		
		for(String key : queryParams.keySet()){
			queryParamsSimple.put(key, queryParams.getFirst(key));
		}
		
		Map<String, String> headers = new HashMap<String, String>();		
		for(String key : httpHeaders.getRequestHeaders().keySet()){
//			System.out.println("Request header: "+key);
			//strip authorization header for internal requests to geoserver
			if(!key.toLowerCase().equals("authorization")) headers.put(key, httpHeaders.getRequestHeaders().getFirst(key));
		}
		
		boolean responseAsStream = true;
		URLResponse response = HttpURLClient.sendRequest(
				to, 
				queryParamsSimple, 
				headers, 
				body!=null ? new String(body) : null,
				method, 
				null, 
				null,
				null,
				false,
				responseAsStream);

		Map<String, List<String>> outputHeaders = pipeOutgoingHeaders(httpHeaders, response.getResponseHeaders(), true);
		response.setResponseHeaders(outputHeaders);
		return finish(response, responseAsStream);
	}
	
	/**
	 * @deprecated
	 * @param inputHeaders
	 * @return
	 */
	public static Map<String, List<String>> pipeGeoserverHeaders(Map<String, List<String>> inputHeaders){
		Map<String, List<String>> outputHeaders = new HashMap<String, List<String>>();
						
		for(String header : inputHeaders.keySet()){			
			if(header!=null){				
				System.out.println("Response header: "+header+": "+inputHeaders.get(header));
				
//				String substituteHeaderKey = "Content-Type";
				if(header.toLowerCase().equals("Content-Type".toLowerCase())){
					
					System.out.println("Replaxce content-tpye");
					
					//Jersey does not like header content-type text/xml; subtype=gml/3.2
					//or it is written incorrectly by Geoserver without escape of subtype containing slash<o
					List<String> adaptedHeader = new ArrayList<String>();			
					for(String value: inputHeaders.get(header)){
						if(value.contains("subtype=gml/")) {
							value = value.replace("subtype=gml/", "subtype=\"gml/");
							value+="\"";
						}				
						adaptedHeader.add(value);			
					}
					outputHeaders.put(header, adaptedHeader);
//					outputHeaders.put(header, Arrays.asList("text/xml; subtype=\"gml/3.2\""));
							
				}
				else{
					String headerValue = "";
					int cnt=0;
					for(String value : inputHeaders.get(header)){
						if(cnt>0) headerValue += "; ";
						headerValue += value;
						cnt++;
					}
					outputHeaders.put(header, Arrays.asList(headerValue));
				}
				
			}
		}
		return outputHeaders;
	}
}
