package de.narimo.georepo.server.layer;

import java.io.IOException;
import java.sql.SQLException;

import org.geotools.feature.FeatureCollection;

import de.narimo.georepo.server.repository.DatasetRepository;
import de.narimo.georepo.server.tools.AdminTools;

public class FeatureLayer {

    public static String getFeatures(int userId, String dataWorkspace, String featureType)
            throws IOException, SQLException {
        int layerId = DatasetRepository.getLayerId(dataWorkspace, featureType);

        boolean isAdmin = AdminTools.isWorkspaceAdmin(userId, dataWorkspace);

        FeatureCollection featureCollection = DatasetRepository.getDatasets(layerId, userId, isAdmin);
        return FeatureBuilder.featureCollectionToJson(featureCollection);
    }

    public static String getFeatureHistory(int userId, String dataWorkspace, String featureType, int gfid)
            throws IOException, SQLException {
        int layerId = DatasetRepository.getLayerId(dataWorkspace, featureType);

        FeatureCollection featureCollection = DatasetRepository.getDatasetHistory(layerId, userId, gfid);
        return FeatureBuilder.featureCollectionToJson(featureCollection);
    }
}
