package de.narimo.georepo.server.repository;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

import javax.ws.rs.NotFoundException;

import org.apache.commons.lang3.RandomStringUtils;

import de.narimo.commons.dto.User;
import de.narimo.commons.jdbc.JDBCConnectionJNDI;

public class AppSettingsRepository {

    public static List<AppKey> getAppKeys(User user) {

        JDBCConnectionJNDI jdbcAuth = null;
        try {

            jdbcAuth = new JDBCConnectionJNDI("jdbc/georepoAuthDatasource");

            String sql = "SELECT appkey, createdat, activatedat FROM public.appkeys"
                    + " WHERE createdby = " + user.getId() + ";";

            ResultSet rs = jdbcAuth.executeQuery(sql);

            List<AppKey> appkeys = new ArrayList<>();

            while (rs.next()) {

                AppKey appkey = new AppKey();
                appkey.setAppKey(rs.getString("appkey"));
                appkey.setCreatedAt(rs.getString("createdat"));
                appkey.setActivatedAt(rs.getString("activatedat"));

                appkeys.add(appkey);
            }
            return appkeys;
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error reading appkeys.");
        } finally {
            if (jdbcAuth != null) {
                jdbcAuth.closeAll();
                jdbcAuth = null;
            }
        }
    }

    public static String createAppKey(User user, AppKey appkey) {

        JDBCConnectionJNDI jdbcAuth = null;
        try {

            jdbcAuth = new JDBCConnectionJNDI("jdbc/georepoAuthDatasource");

            if (appkey.getTemplateKey() != null) {
                PreparedStatement ps0 = jdbcAuth.prepareStatement("SELECT * FROM public.appkeys WHERE appkey=?");
                ps0.setString(1, appkey.getTemplateKey());

                ResultSet rs0 = ps0.executeQuery();

                if (!rs0.next()) {
                    throw new NotFoundException("Template key does not exist.");
                }
            }

            String sql = "INSERT INTO public.appkeys (templatekey, organisation, ownername, address_street, address_streetnumber, address_postcode, address_city, createdby, appkey)"
                    + " VALUES(?,?,?,?,?,?,?,?,?) RETURNING appkey;";

            PreparedStatement ps = jdbcAuth.prepareStatement(sql);
            ps.setString(1, appkey.getTemplateKey());
            ps.setString(2, appkey.getOrganisation());
            ps.setString(3, appkey.getOwnerName());
            ps.setString(4, appkey.getAddressStreet());
            ps.setString(5, appkey.getAddressStreetnumber());
            ps.setString(6, appkey.getAddressPostcode());
            ps.setString(7, appkey.getAddressCity());
            ps.setInt(8, user.getId());
            ps.setString(9, createAppKey());

            ResultSet rs = ps.executeQuery();

            if (rs.next()) {
                return rs.getString("appkey");
            }
            throw new RuntimeException("Could not insert appkey.");

        } catch (NotFoundException e) {
            e.printStackTrace();
            throw new NotFoundException(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot create appkey.");
        } finally {
            if (jdbcAuth != null) {
                jdbcAuth.closeAll();
                jdbcAuth = null;
            }
        }
    }

    private static String createAppKey() { return RandomStringUtils.randomAlphanumeric(32); }

    public static List<AppDetails> getAppDetails(String appkey) {

        JDBCConnectionJNDI jdbcAuth = null;
        try {

            jdbcAuth = new JDBCConnectionJNDI("jdbc/georepoAuthDatasource");

            String sql = "SELECT appkey, description, descriptiontitle FROM public.appdetails"
                    + " WHERE appkey = ?;";

            PreparedStatement ps = jdbcAuth.prepareStatement(sql);
            ps.setString(1, appkey);
            ResultSet rs = jdbcAuth.executePreparedQuery(ps);

            List<AppDetails> appDetails = new ArrayList<>();
            while (rs.next()) {

                if (rs.getString("appkey").equals(appkey)) {
                    AppDetails appDetail = new AppDetails();
                    appDetail.setDescription(rs.getString("description"));
                    appDetail.setDescriptionTitle(rs.getString("descriptiontitle"));
                    appDetails.add(appDetail);
                }
            }
            return appDetails;
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error reading app details.");
        } finally {
            if (jdbcAuth != null) {
                jdbcAuth.closeAll();
                jdbcAuth = null;
            }
        }
    }
}
