package de.narimo.georepo.server.tools;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;

public class GeometryTools {

    /**
     * Create a single point geometry instance.
     *
     * @param x
     * @param y
     * @param gf
     * @return
     */
    public static Geometry createPointGeometry(double x, double y, GeometryFactory gf) {
        Coordinate coordinate = new Coordinate(x, y);
        Point point = gf.createPoint(coordinate);
        return gf.createGeometry(point);
    }

    public static Geometry createGeometry(String wkt) throws ParseException {
        WKTReader reader = new WKTReader();
        return reader.read(wkt);
    }

    public static String createWKT(Geometry geom) throws ParseException {
        WKTWriter writer = new WKTWriter();
        return writer.write(geom);
    }
}
