package de.narimo.georepo.server.tools;

import org.apache.commons.lang3.StringUtils;

import de.narimo.georepo.server.GeorepoConstants;

public class QueryCheck {

    public static void checkTableName(String tableName) {
        if (tableName == null || tableName.isEmpty() || StringUtils.containsWhitespace(tableName)
                || tableName.contains(";")) {
            throw new IllegalArgumentException("Table name " + tableName + " is not supported as a table name.");
        }
    }

    public static void checkDiffTableName(String tableName) {
        if (tableName == null || tableName.isEmpty() || !tableName.contains(GeorepoConstants.diffTableSuffix)) {
            throw new IllegalArgumentException("Table name " + tableName + " is not supported as a diff table name.");
        }
    }
}
