package de.narimo.georepo.server.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

import de.narimo.commons.dto.RegistrationLanguage;

public class Translator {

    private Properties languagePropertiesEN_US = new Properties();
    private Properties languagePropertiesDE = new Properties();
    private Properties languagePropertiesES = new Properties();
    private Properties languagePropertiesFR = new Properties();

    public Translator() {
        try {
            languagePropertiesDE
                    .load(new FileInputStream(new File(this.getClass().getResource("language_de.txt").getFile())));
            languagePropertiesEN_US
                    .load(new FileInputStream(new File(this.getClass().getResource("language_en_us.txt").getFile())));
            languagePropertiesES
                    .load(new FileInputStream(new File(this.getClass().getResource("language_es.txt").getFile())));
            languagePropertiesFR
                    .load(new FileInputStream(new File(this.getClass().getResource("language_fr.txt").getFile())));
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * Translates a language key into the desired language. Returns EN_US
     * translation, if there does not exist a translation for the desired language.
     * 
     * @param key
     * @param language
     * @param args
     * @return
     */
    public String translate(String key, RegistrationLanguage language, String... args) {
        return String.format(getTranslations(language).getProperty(key), (Object[]) args);
    }

    private Properties getTranslations(RegistrationLanguage language) {
        if (language == null) {
            return languagePropertiesEN_US;
        }
        switch (language) {
        case DE:
            return languagePropertiesDE;
        case ES:
            return languagePropertiesES;
        case FR:
            return languagePropertiesFR;
        default:
            return languagePropertiesEN_US;
        }
    }
}
