package de.narimo.georepo.server.api;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;

import de.narimo.georepo.server.api.observations.Observation;
import de.narimo.georepo.server.api.observations.ObservationsService;
import de.narimo.georepo.server.repository.DatasetRepository;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;

@Provider
@Path("/workspaces/{workspace}/layers/{layername}/observations")
@Tag(name = "Observations")
public class ObservationsLayerController {

    ObservationsService observationsService = new ObservationsService();

    @GET
    @Path("/")
    @Produces({ MediaType.APPLICATION_JSON })
    @Operation(summary = "Retrieve observations by search term")
    public Response getObservationsBySearchTerm(
            @Context SecurityContext sec,
            @PathParam("workspace") String workspace,
            @PathParam("layername") String dataLayerName,
            @QueryParam("search") String searchTerm) {

        try {
            int layerId = DatasetRepository.getLayerId(workspace, dataLayerName);

            List<Observation> observations = new ArrayList<>();
            observations = observationsService.getObservationsBySearchTerm(layerId, searchTerm);

            return Response.ok().entity(observations).build();

        } catch (SQLException e) {
            e.printStackTrace();
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}
