package de.narimo.georepo.server.api;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;

import de.narimo.commons.dto.User;
import de.narimo.geocore.ws.repository.UserRepository;
import de.narimo.georepo.server.api.tags.GeorepoTag;
import de.narimo.georepo.server.api.tags.TagService;
import de.narimo.georepo.server.repository.DatasetRepository;
import de.narimo.georepo.server.repository.DifftableRepository;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;

@Provider
@Path("/workspaces/{diffWorkspace}/layers/{layername}/tags")
@Tag(name = "Tags")
public class TagsDiffLayerController {

    TagService tagService = new TagService();

    @GET
    @Path("/changes")
    @Consumes({ MediaType.APPLICATION_JSON })
    @Produces({ MediaType.APPLICATION_JSON })
    @Operation(summary = "Retrieve all unreviewed tags of a layer")
    public Response addFeatureTags(
            @Context SecurityContext sec,
            @PathParam("diffWorkspace") String diffWorkspace,
            @PathParam("layername") String dataLayerName)
            throws IOException, SQLException {

        try {
            User user = UserRepository.getUser(sec.getUserPrincipal().getName()).get();

            String dataWorkspace = DifftableRepository.getDataWorkspace(diffWorkspace, dataLayerName);
            if (dataWorkspace == null) {
                throw new InternalError("No data workspace defined.");
            }

            int layerId = DatasetRepository.getLayerId(dataWorkspace, dataLayerName);
            List<GeorepoTag> tags = tagService.getUnreviewedTags(layerId, dataWorkspace,
                    user);
            return Response.ok().entity(tags).build();
        } catch (InternalError e) {
            e.printStackTrace();
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}