package de.narimo.georepo.server.api.account;

import java.io.InputStream;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;

import de.narimo.commons.dto.User;
import de.narimo.geocore.ws.registration.UserRegistrationDetails;
import de.narimo.geocore.ws.repository.UserRepository;
import de.narimo.georepo.server.api.AccountService;
import de.narimo.georepo.server.appconfig.AppKey;
import de.narimo.georepo.server.appconfig.AppSettingsService;
import de.narimo.georepo.server.notification.Notifier;
import io.swagger.v3.oas.annotations.tags.Tag;

@Provider
@Path("/account")
@Tag(name = "AccountController")
public class AccountController {

    AccountService accountService = new AccountService();

    /**
     * TODO: notify workspace admin(s) about account removal
     * 
     * @param ctx
     * @param sec
     * @param body
     * @return
     */
    @POST
    @Path("/remove")
    public Response removeUserAccount(
            @Context ServletContext ctx,
            @Context SecurityContext sec,
            @Context HttpServletRequest request,
            InputStream body) {

        try {

//            String clientApp = null;
//            try {
//                ObjectMapper mapper = new ObjectMapper();
//                AccountDeletionDetails details = mapper.readValue(body, AccountDeletionDetails.class);
//                clientApp = details.getClientApp();
//            } catch (JsonMappingException e) {
//            }

            User user = UserRepository.getUser(sec.getUserPrincipal().getName()).get();

            AppKey appkeyFromHeader = AppSettingsService.getAppKeyFromHeader(request);
            String appAlias = appkeyFromHeader == null ? null : appkeyFromHeader.getAlias();
            Notifier notifier = Notifier.getInstance(ctx, appkeyFromHeader);
            try {
                // disable account in database
                accountService.disableUser(user.getId());

                // notify narimo
                notifier.notifyNarimoAboutAccountRemoval(user.getEmail(), appAlias, user.getLanguage());
            } catch (InternalError e) {
                notifier.notifyNarimoAboutFailedAccountRemoval(user.getEmail(), appAlias, user.getLanguage());
            }

            // always send notification to user, even if removal failed
            notifier.notifyUserAboutAccountDeletion(user.getEmail(), appAlias, user.getLanguage());
            return Response.ok().build();
        } catch (NotFoundException e) {
            return Response.status(Status.NOT_FOUND).build();
        } catch (InternalError | RuntimeException e) {
            e.printStackTrace();
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @Path("/")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public Response saveUserAccount(@Context ServletContext ctx, @Context SecurityContext sec,
            UserRegistrationDetails userAccountDetails) {

        try {
            System.out.println("LANG: " + userAccountDetails.getLanguage());
            User user = UserRepository.getUser(sec.getUserPrincipal().getName()).get();
            accountService.saveUser(user.getId(), userAccountDetails);
            user = UserRepository.getUser(sec.getUserPrincipal().getName()).get();
            return Response.ok(user).build();
        } catch (NotFoundException e) {
            return Response.status(Status.NOT_FOUND).build();
        } catch (InternalError | RuntimeException e) {
            e.printStackTrace();
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        }

    }
}
