package de.narimo.georepo.server.api.layers;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

import javax.servlet.ServletContext;

import org.geotools.feature.FeatureCollection;
import org.opengis.feature.simple.SimpleFeature;

import de.narimo.commons.dto.User;
import de.narimo.georepo.server.api.workspaces.Workspace;
import de.narimo.georepo.server.layer.FeatureBuilder;
import de.narimo.georepo.server.repository.DatasetRepository;
import de.narimo.georepo.server.repository.DiffDatasetRepository;
import de.narimo.georepo.server.repository.DifftableRepository;
import de.narimo.georepo.server.tools.TableTools;

public class DiffFeatureLayer {

    public static String getModifiedFeatures(int userId, String dataWorkspace, String featureType, boolean asAdmin)
            throws IOException, SQLException {
        int layerId = DatasetRepository.getLayerId(dataWorkspace, featureType);
        String diffTableName = TableTools.getDiffTableName(layerId);
        String diffAuthTableName = TableTools.getDiffAuthTableName(layerId);

        FeatureCollection featureCollection = null;

        boolean diffTableExists = DifftableRepository.checkDiffTableExists(diffTableName);
        if (diffTableExists) {
            featureCollection = DiffDatasetRepository.getModifiedDatasets(diffTableName,
                    diffAuthTableName, userId, asAdmin);
        }
        return FeatureBuilder.featureCollectionToJson(featureCollection);
    }

    public static void addNewFeatures(ServletContext ctx, User user, Workspace dataWorkspace, String featureType,
            List<SimpleFeature> features)
            throws IOException, SQLException {

        int layerId = DatasetRepository.getLayerId(dataWorkspace.getName(), featureType);
        String diffTableName = TableTools.getDiffTableName(layerId);
        String diffAuthTableName = TableTools.getDiffAuthTableName(layerId);

        boolean diffTableExists = DifftableRepository.checkDiffTableExists(diffTableName);
        if (!diffTableExists) {
            DiffLayerService.createDiffLayer(ctx, dataWorkspace, featureType, user);
        }

        DiffDatasetRepository.insertDatasets(diffTableName, diffAuthTableName, features, user.getId());
    }

    public static void addModifiedFeatures(ServletContext ctx, User user, Workspace dataWorkspace, String featureType,
            List<SimpleFeature> features) throws IOException, SQLException {

        int layerId = DatasetRepository.getLayerId(dataWorkspace.getName(), featureType);
        String diffTableName = TableTools.getDiffTableName(layerId);
        String diffAuthTableName = TableTools.getDiffAuthTableName(layerId);

        boolean diffTableExists = DifftableRepository.checkDiffTableExists(diffTableName);
        if (!diffTableExists) {
            DiffLayerService.createDiffLayer(ctx, dataWorkspace, featureType, user);
        }

        DiffDatasetRepository.updateDatasets(diffTableName, diffAuthTableName, features, user.getId());
    }

    public static void addDeletedFeatures(ServletContext ctx, User user, Workspace dataWorkspace, String featureType,
            List<SimpleFeature> features) throws IOException, SQLException {

        int dataLayerId = DatasetRepository.getLayerId(dataWorkspace.getName(), featureType);
        String diffTableName = TableTools.getDiffTableName(dataLayerId);
        String diffAuthTableName = TableTools.getDiffAuthTableName(dataLayerId);

        boolean diffTableExists = DifftableRepository.checkDiffTableExists(diffTableName);
        if (!diffTableExists) {
            DiffLayerService.createDiffLayer(ctx, dataWorkspace, featureType, user);
        }

        DiffDatasetRepository.deleteDatasets(diffTableName, diffAuthTableName, features, user.getId());
    }

    public static void acceptFeatureChange(int grpfid, String dataWorkspace, String dataFeatureType)
            throws IOException {

        int dataLayerId = DatasetRepository.getLayerId(dataWorkspace, dataFeatureType);
        DiffDatasetRepository.acceptDataset(dataLayerId, grpfid);
    }

    public static void declineFeatureChange(int grpfid, String dataWorkspace, String featureType) throws IOException {
        int dataLayerId = DatasetRepository.getLayerId(dataWorkspace, featureType);
        String diffTable = TableTools.getDiffTableName(dataLayerId);
        String diffAuthTableName = TableTools.getDiffAuthTableName(dataLayerId);

        DiffDatasetRepository.declineDataset(diffTable, diffAuthTableName, grpfid);
    }
}
