package de.narimo.georepo.server.api.layers;

import java.io.IOException;
import java.sql.SQLException;

import javax.servlet.ServletContext;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;

import de.narimo.commons.dto.User;
import de.narimo.geocore.ws.repository.UserRepository;
import de.narimo.georepo.server.api.workspaces.Workspace;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;

@Provider
@Path("/workspaces/{workspace}/layers/")
@Tag(name = "Diff Layers", description = "A diff layer holds temporary changes relative to the original layer. "
        + "Changes need to be accepted by a user with admin permissions to be visible on the original layer.")
public class DiffLayerController {

    /**
     * Creates a new diff and auth table together with a diff workspace and inserts
     * to table difftables.
     *
     * @param sec
     * @param ctx
     * @param dataWorkspace
     * @param dataLayerName
     * @param userName
     * @return
     * @throws IOException
     */
    @PUT
    @Path("/{layername}/managed")
    @Operation(summary = "Creates a new diff layer", description = "Also createst a new diff workspace if none exists for the current workspace.")
    public static Response createManageableDiffLayer(
            @Context SecurityContext sec,
            @Context ServletContext ctx,
            @PathParam("workspace") String dataWorkspace,
            @PathParam("layername") String dataLayerName)
            throws IOException {

        try {
            String username = sec.getUserPrincipal().getName();
            User user = UserRepository.getUser(username).get();

            DiffLayerService.createDiffLayer(ctx, new Workspace(dataWorkspace), dataLayerName, user);

        } catch (ForbiddenException e) {
            e.printStackTrace();
            return Response.status(Status.FORBIDDEN).build();
        } catch (IllegalArgumentException | NotFoundException e) {
            e.printStackTrace();
            return Response.status(Status.BAD_REQUEST).build();
        } catch (SQLException e) {
            e.printStackTrace();
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        } catch (Exception e) {
            e.printStackTrace();
            Response.status(Status.BAD_REQUEST).entity("Could not create manageable layer. ").build();
        }

        return Response.ok().build();
    }
}
