package de.narimo.georepo.server.api.layers;

import java.io.IOException;
import java.sql.SQLException;

import javax.servlet.ServletContext;

import de.narimo.commons.dto.User;
import de.narimo.georepo.server.api.workspaces.Workspace;
import de.narimo.georepo.server.api.workspaces.WorkspaceService;
import de.narimo.georepo.server.repository.DatasetRepository;
import de.narimo.georepo.server.repository.DifftableRepository;
import de.narimo.georepo.server.tools.AdminTools;
import de.narimo.georepo.server.tools.TableTools;

public class DiffLayerService {

    static void createDiffLayer(ServletContext ctx, Workspace dataWorkspace, String layerName, User user)
            throws SQLException, IOException {

        AdminTools.checkAdminPermission(user.getId(), dataWorkspace.getName());

        int layerId = DatasetRepository.getLayerId(dataWorkspace.getName(), layerName);
        String diffTable = TableTools.getDiffTableName(layerId);

        boolean diffTableExists = DifftableRepository.checkDiffTableExists(diffTable);
        if (!diffTableExists) {
            System.out.println("Diff table does not yet exist. Creating it...");

//            Workspace diffWorkspace = new Workspace();

            // Only create a new diff workspace if none exists for that dataWorkspace!
            // That is, we have to maintain a 1:1 relation between dataWorkspace and
            // diffWorkspace
//            diffWorkspace.setName(DifftableRepository.getDiffWorkspace(dataWorkspace));
//            System.out.println(
//                    "Diffworkspace for dataWorkspace " + dataWorkspace + " is " + diffWorkspace.getName() + ".");
//
//            if (diffWorkspace.getName() == null) {
//                try {
//                    diffWorkspace = WorkspacesController.createDiffWorkspace(ctx, user);
//                    // this adds admin permission for the workspace
//                    // since the user also has admin permissions for the data workspace
//                    WorkspaceService.setInitialWorkspacePermission(user, diffWorkspace);
//                } catch (IOException e) {
//                    if (!e.getMessage().contains("Enabling/ Disabling of transaction support")) {
//                        throw e;
//                    } else {
//                        // This is expected behaviour since the workspace
//                        // needs to be activated for WMS/ WFS access.
//                        // We don't need it in this case, so we ignore it.
//                    }
//                }
//            }
            Workspace diffWorkspace = WorkspaceService.createOrGetDiffWorkspace(ctx, dataWorkspace, user);

            String dataTable = TableTools.getDataTableName(layerId);
            String diffAuthTable = TableTools.getDiffAuthTableName(layerId);

            DifftableRepository.createDiffTable(dataTable, diffTable);
            DifftableRepository.createDiffAuthTable(diffAuthTable);

            // Do NOT add to table datasets!
            // Only datasets imported with import will be placed there to
            // determine the data table id

            // add diff table to a workspace, i.e.
            // add diff table to difftables table
            DifftableRepository.addDiffLayer(TableTools.getDiffLayerName(layerName),
                    diffWorkspace.getName(), layerName, dataWorkspace.getName());

        } else {
            System.out.println("Diff table " + diffTable + " exists. Assuming, a manageable layer for "
                    + layerName + " already exists.");
        }
    }
}
