package de.narimo.georepo.server.api.species;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

import de.narimo.commons.dto.User;

public class SpeciesService {

    public List<Species> getSpecies(int layerId)
            throws SQLException {

        boolean speciesTableExists = SpeciesRepository.checkSpeciesTableExists(layerId);
        if (!speciesTableExists) {
            System.out.println("Species table does not yet exist for layer " + layerId + ". No species present.");
            return Arrays.asList();
        }
        return SpeciesRepository.getSpecies(layerId);
    }

    public void addSpecies(int layerId, User user, Species species) throws SQLException {
        boolean specTableExists = SpeciesRepository.checkSpeciesTableExists(layerId);
        if (!specTableExists) {
            System.out.println("Species table does not yet exist for layer " + layerId + ". Creating it...");
            SpeciesRepository.createSpeciesTable(layerId);
        }
        SpeciesRepository.insertSpecies(layerId, user.getId(), species);
    }
}
