package de.narimo.georepo.server.api.tags;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

import de.narimo.commons.dto.User;
import de.narimo.georepo.server.repository.TagRepository;
import de.narimo.georepo.server.tools.TableTools;

public class TagService {

    public List<String> getTags(int layerId)
            throws SQLException {

        // if no tags table exists, return empty list
        boolean tagsTableExists = TagRepository.checkTagTableExists(layerId);
        if (!tagsTableExists) {
            System.out.println("Tags table does not yet exist for layer " + layerId + ". No tags present.");
            return Arrays.asList();
        }
        return TagRepository.getTags(layerId);
    }

    public List<GeorepoTag> getUnreviewedTags(int layerId, String workspace, User user)
            throws SQLException {

        // if no tags table exists, return empty list
        boolean tagsTableExists = TagRepository.checkTagTableExists(layerId);
        if (!tagsTableExists) {
            System.out.println("Tags table does not yet exist for layer " + layerId + ". No tags present.");
            return Arrays.asList();
        }
        return TagRepository.getUnreviewedTags(layerId, workspace, user);
    }

    public void addTags(int layerId, int userId, int gfid, List<String> tags)
            throws SQLException {
        // create tag table, if none exists
        TagRepository.createTagTable(layerId);
        TagRepository.addNewTagsSuggestion(layerId, userId, gfid, tags);
    }

    public void removeTags(int layerId, int userId, int gfid, List<String> tags)
            throws SQLException {
        TagRepository.addDeleteTagsSuggestion(layerId, userId, gfid, tags);
    }

    public void acceptTag(int layerId, int gfid, int tagId) {
        String tagTable = TableTools.getTagTableName(layerId);
        TagRepository.acceptTag(tagTable, gfid, tagId);
    }

    public void declineTag(int layerId, int gfid, int tagId) {
        String tagTable = TableTools.getTagTableName(layerId);
        TagRepository.declineTag(tagTable, gfid, tagId);
    }
}
