package de.narimo.georepo.server.appconfig;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;

@JsonInclude(Include.NON_NULL)
public class AppConfiguration {

    private String appKey;
    private String appName;
    private String appNameInternal;
    private String appVersion;
    private String appIcon;
    private String appUrl;
    private GeorepoConfigSearch search;
    private GeorepoConfigAuth auth;
    private Boolean appFooter;
    private Boolean routing;
    private Boolean geolocation;
    private Boolean geolocationFeaturesVisible;
    private String serverUrl;
    private Boolean useCookies;
    private String navigationService;
    private String featuresPropertiesWindow;
    private Boolean startZoomUserCentered;
    private Boolean requireAuth;
    private Boolean registerUsersOnWorkspace;
    private String nameComponentFeatureDetail;
    private Boolean sliderAutostart;
    private Boolean isPublicApp;
    private Boolean activeAddNewPoiAtLocation;
    private String defaultLeftDrawerComponent;
    private List<String> leftDrawerComponent;
    private List<String> rightDrawerComponent;
    private Boolean comments;
    private Boolean documents;
    private Boolean links;
    private GeorepoConfigImageSize sizeLimitImage;
    private String timeZone;
    private String timeFormat;
    private Boolean settingsDrawer;
    private String defaultSettingsPage;
    private Integer fontSize;
    private String themeMode;
    private String primaryColor;
    private String secondaryColor;
    private String accentColor;
    private Integer shortPrecisionCoordinates;
    private Boolean tagsSearch;
    private Boolean observationsSearch;
    private String observationsTitle;
    private Boolean openObservations;
    private String aboutPageTitle;
    private Boolean isOrderApp;
    private String defaultLanguage;

    public String getAppKey() { return appKey; }

    public void setAppKey(String appKey) { this.appKey = appKey; }

    public String getAppName() { return appName; }

    public void setAppName(String appName) { this.appName = appName; }

    public String getAppNameInternal() { return appNameInternal; }

    public void setAppNameInternal(String appNameInternal) { this.appNameInternal = appNameInternal; }

    public String getAppVersion() { return appVersion; }

    public void setAppVersion(String appVersion) { this.appVersion = appVersion; }

    public String getAppIcon() { return appIcon; }

    public void setAppIcon(String appIcon) { this.appIcon = appIcon; }

    public String getAppUrl() { return appUrl; }

    public void setAppUrl(String appUrl) { this.appUrl = appUrl; }

    public GeorepoConfigSearch getSearch() { return search; }

    public void setSearch(GeorepoConfigSearch search) { this.search = search; }

    public GeorepoConfigAuth getAuth() { return auth; }

    public void setAuth(GeorepoConfigAuth auth) { this.auth = auth; }

    public Boolean getAppFooter() { return appFooter; }

    public void setAppFooter(Boolean appFooter) { this.appFooter = appFooter; }

    public Boolean getRouting() { return routing; }

    public void setRouting(Boolean routing) { this.routing = routing; }

    public Boolean getGeolocation() { return geolocation; }

    public void setGeolocation(Boolean geolocation) { this.geolocation = geolocation; }

    public Boolean getGeolocationFeaturesVisible() { return geolocationFeaturesVisible; }

    public void setGeolocationFeaturesVisible(Boolean geolocationFeaturesVisible) {
        this.geolocationFeaturesVisible = geolocationFeaturesVisible;
    }

    public String getServerUrl() { return serverUrl; }

    public void setServerUrl(String serverUrl) { this.serverUrl = serverUrl; }

    public Boolean getUseCookies() { return useCookies; }

    public void setUseCookies(Boolean useCookies) { this.useCookies = useCookies; }

    public String getNavigationService() { return navigationService; }

    public void setNavigationService(String navigationService) { this.navigationService = navigationService; }

    public String getFeaturesPropertiesWindow() { return featuresPropertiesWindow; }

    public void setFeaturesPropertiesWindow(String featuresPropertiesWindow) {
        this.featuresPropertiesWindow = featuresPropertiesWindow;
    }

    public Boolean getStartZoomUserCentered() { return startZoomUserCentered; }

    public void setStartZoomUserCentered(Boolean startZoomUserCentered) {
        this.startZoomUserCentered = startZoomUserCentered;
    }

    public Boolean getRequireAuth() { return requireAuth; }

    public void setRequireAuth(Boolean requireAuth) { this.requireAuth = requireAuth; }

    public Boolean getRegisterUsersOnWorkspace() { return registerUsersOnWorkspace; }

    public void setRegisterUsersOnWorkspace(Boolean registerUsersOnWorkspace) {
        this.registerUsersOnWorkspace = registerUsersOnWorkspace;
    }

    public String getNameComponentFeatureDetail() { return nameComponentFeatureDetail; }

    public void setNameComponentFeatureDetail(String nameComponentFeatureDetail) {
        this.nameComponentFeatureDetail = nameComponentFeatureDetail;
    }

    public Boolean getSliderAutostart() { return sliderAutostart; }

    public void setSliderAutostart(Boolean sliderAutostart) { this.sliderAutostart = sliderAutostart; }

    public Boolean getIsPublicApp() { return isPublicApp; }

    public void setIsPublicApp(Boolean isPublicApp) { this.isPublicApp = isPublicApp; }

    public Boolean getActiveAddNewPoiAtLocation() { return activeAddNewPoiAtLocation; }

    public void setActiveAddNewPoiAtLocation(Boolean activeAddNewPoiAtLocation) {
        this.activeAddNewPoiAtLocation = activeAddNewPoiAtLocation;
    }

    public String getDefaultLeftDrawerComponent() { return defaultLeftDrawerComponent; }

    public void setDefaultLeftDrawerComponent(String defaultLeftDrawerComponent) {
        this.defaultLeftDrawerComponent = defaultLeftDrawerComponent;
    }

    public List<String> getLeftDrawerComponent() { return leftDrawerComponent; }

    public void setLeftDrawerComponent(List<String> leftDrawerComponent) {
        this.leftDrawerComponent = leftDrawerComponent;
    }

    public List<String> getRightDrawerComponent() { return rightDrawerComponent; }

    public void setRightDrawerComponent(List<String> rightDrawerComponent) {
        this.rightDrawerComponent = rightDrawerComponent;
    }

    public Boolean getComments() { return comments; }

    public void setComments(Boolean comments) { this.comments = comments; }

    public Boolean getDocuments() { return documents; }

    public void setDocuments(Boolean documents) { this.documents = documents; }

    public Boolean getLinks() { return links; }

    public void setLinks(Boolean links) { this.links = links; }

    public GeorepoConfigImageSize getSizeLimitImage() { return sizeLimitImage; }

    public void setSizeLimitImage(GeorepoConfigImageSize sizeLimitImage) { this.sizeLimitImage = sizeLimitImage; }

    public String getTimeZone() { return timeZone; }

    public void setTimeZone(String timeZone) { this.timeZone = timeZone; }

    public String getTimeFormat() { return timeFormat; }

    public void setTimeFormat(String timeFormat) { this.timeFormat = timeFormat; }

    public Boolean getSettingsDrawer() { return settingsDrawer; }

    public void setSettingsDrawer(Boolean settingsDrawer) { this.settingsDrawer = settingsDrawer; }

    public String getDefaultSettingsPage() { return defaultSettingsPage; }

    public void setDefaultSettingsPage(String defaultSettingsPage) { this.defaultSettingsPage = defaultSettingsPage; }

    public Integer getFontSize() { return fontSize; }

    public void setFontSize(Integer fontSize) { this.fontSize = fontSize; }

    public String getThemeMode() { return themeMode; }

    public void setThemeMode(String themeMode) { this.themeMode = themeMode; }

    public String getPrimaryColor() { return primaryColor; }

    public void setPrimaryColor(String primaryColor) { this.primaryColor = primaryColor; }

    public String getSecondaryColor() { return secondaryColor; }

    public void setSecondaryColor(String secondaryColor) { this.secondaryColor = secondaryColor; }

    public String getAccentColor() { return accentColor; }

    public void setAccentColor(String accentColor) { this.accentColor = accentColor; }

    public Integer getShortPrecisionCoordinates() { return shortPrecisionCoordinates; }

    public void setShortPrecisionCoordinates(Integer shortPrecisionCoordinates) {
        this.shortPrecisionCoordinates = shortPrecisionCoordinates;
    }

    public Boolean getTagsSearch() { return tagsSearch; }

    public void setTagsSearch(Boolean tagsSearch) { this.tagsSearch = tagsSearch; }

    public Boolean getObservationsSearch() { return observationsSearch; }

    public void setObservationsSearch(Boolean observationsSearch) { this.observationsSearch = observationsSearch; }

    public String getObservationsTitle() { return observationsTitle; }

    public void setObservationsTitle(String observationsTitle) { this.observationsTitle = observationsTitle; }

    public Boolean getOpenObservations() { return openObservations; }

    public void setOpenObservations(Boolean openObservations) { this.openObservations = openObservations; }

    public String getAboutPageTitle() { return aboutPageTitle; }

    public void setAboutPageTitle(String aboutPageTitle) { this.aboutPageTitle = aboutPageTitle; }

    public Boolean getIsOrderApp() { return isOrderApp; }

    public void setIsOrderApp(Boolean isOrderApp) { this.isOrderApp = isOrderApp; }

    public String getDefaultLanguage() { return defaultLanguage; }

    public void setDefaultLanguage(String defaultLanguage) { this.defaultLanguage = defaultLanguage; }

}
