package de.narimo.georepo.server.appconfig;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(Include.NON_NULL)
public class AppLayerConfiguration {

    private String id;
    private String name;
    private String icon;
    private String type;
    private String workspace;
    private String georeponame;
    private List<String> categories;
    private List<GeorepoConfigTag> tags;
    private Boolean visible;
    private Boolean legend;
    private Boolean edit;
    private Boolean translate;
    private Boolean clearable;
    private Boolean selectable;
    private Boolean navigation;

    @JsonProperty("class")
    private String classType;

    private Boolean declutter;
    private Boolean searchable;
    private Boolean primaryLayer;
    private String nameProperty;
    private String categoryProperty;
    private String areaProperty;
    private String descriptionProperty;
    private String strokeColor;
    private String strokeWidth;
    private String fillColor;
    private List<GeorepoConfigLayerProperties> properties;
    private String style;
    private Boolean fromLocal;

    public String getId() { return id; }

    public void setId(String id) { this.id = id; }

    public String getName() { return name; }

    public void setName(String name) { this.name = name; }

    public String getIcon() { return icon; }

    public void setIcon(String icon) { this.icon = icon; }

    public String getType() { return type; }

    public void setType(String type) { this.type = type; }

    public String getWorkspace() { return workspace; }

    public void setWorkspace(String workspace) { this.workspace = workspace; }

    public String getGeoreponame() { return georeponame; }

    public void setGeoreponame(String georeponame) { this.georeponame = georeponame; }

    public List<String> getCategories() { return categories; }

    public void setCategories(List<String> categories) { this.categories = categories; }

    public List<GeorepoConfigTag> getTags() { return tags; }

    public void setTags(List<GeorepoConfigTag> tags) { this.tags = tags; }

    public Boolean getVisible() { return visible; }

    public void setVisible(Boolean visible) { this.visible = visible; }

    public Boolean getLegend() { return legend; }

    public void setLegend(Boolean legend) { this.legend = legend; }

    public Boolean getEdit() { return edit; }

    public void setEdit(Boolean edit) { this.edit = edit; }

    public Boolean getTranslate() { return translate; }

    public void setTranslate(Boolean translate) { this.translate = translate; }

    public Boolean getClearable() { return clearable; }

    public void setClearable(Boolean clearable) { this.clearable = clearable; }

    public Boolean getSelectable() { return selectable; }

    public void setSelectable(Boolean selectable) { this.selectable = selectable; }

    public Boolean getNavigation() { return navigation; }

    public void setNavigation(Boolean navigation) { this.navigation = navigation; }

    public String getClassType() { return classType; }

    public void setClassType(String classType) { this.classType = classType; }

    public Boolean getDeclutter() { return declutter; }

    public void setDeclutter(Boolean declutter) { this.declutter = declutter; }

    public Boolean getSearchable() { return searchable; }

    public void setSearchable(Boolean searchable) { this.searchable = searchable; }

    public Boolean getPrimaryLayer() { return primaryLayer; }

    public void setPrimaryLayer(Boolean primaryLayer) { this.primaryLayer = primaryLayer; }

    public String getNameProperty() { return nameProperty; }

    public void setNameProperty(String nameProperty) { this.nameProperty = nameProperty; }

    public String getCategoryProperty() { return categoryProperty; }

    public void setCategoryProperty(String categoryProperty) { this.categoryProperty = categoryProperty; }

    public String getAreaProperty() { return areaProperty; }

    public void setAreaProperty(String areaProperty) { this.areaProperty = areaProperty; }
    
    public String getDescriptionProperty() { return descriptionProperty; }

    public void setDescriptionProperty(String descriptionProperty) { this.descriptionProperty = descriptionProperty; }

    public String getStrokeColor() { return strokeColor; }

    public void setStrokeColor(String strokeColor) { this.strokeColor = strokeColor; }

    public String getFillColor() { return fillColor; }

    public void setFillColor(String fillColor) { this.fillColor = fillColor; }

    public List<GeorepoConfigLayerProperties> getProperties() { return properties; }

    public void setProperties(List<GeorepoConfigLayerProperties> properties) { this.properties = properties; }

    public String getStyle() { return style; }

    public void setStyle(String style) { this.style = style; }

    public String getStrokeWidth() { return strokeWidth; }

    public void setStrokeWidth(String strokeWidth) { this.strokeWidth = strokeWidth; }

    public Boolean getFromLocal() { return fromLocal; }

    public void setFromLocal(Boolean fromLocal) { this.fromLocal = fromLocal; }

}
