package de.narimo.georepo.server.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Class used to resolve geoserver feature type response.
 * 
 * @author Ulrich Mann
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class GeoserverFeatureType {

    public String name;
    public String title;
    public String href;

    @JsonProperty("@abstract")
    public String description;

    public String getName() { return name; }

    public void setName(String name) { this.name = name; }

    public String getHref() { return href; }

    public void setHref(String href) { this.href = href; }

    public String getDescription() { return description; }

    public void setDescription(String description) { this.description = description; }

    public String getTitle() { return title; }

    public void setTitle(String title) { this.title = title; }
}
