package de.narimo.georepo.server.filter;

import java.io.IOException;

import javax.annotation.Priority;
import javax.ws.rs.Priorities;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;

@Provider
@Priority(Priorities.USER)
public class ResponseFilter implements ContainerResponseFilter {
    public void filter(ContainerRequestContext crc, ContainerResponseContext response) throws IOException {
        // prevent caching for all georepo responses
        response.getHeaders().add("Cache-Control", "no-cache, no-store, must-revalidate"); // HTTP 1.1.
        response.getHeaders().add("Pragma", "no-cache"); // HTTP 1.0.
        response.getHeaders().add("Expires", "0"); // Proxies.

        if ("cors".equals(crc.getHeaderString("Sec-Fetch-Mode"))) {
            // grs-197: allow cors-requests (js client requirement)
            // grs-204: only allow cors for requests from localhost
            String currentOrigin = crc.getHeaderString("Origin");
            if (currentOrigin != null && currentOrigin.startsWith("http://localhost")) {
                response.getHeaders().add("Access-Control-Allow-Origin", currentOrigin);
                response.getHeaders().add("Vary", "Origin");
                response.getHeaders().add("Access-Control-Allow-Methods", "OPTIONS, GET, POST, PUT, DELETE");
            }

            String accessControlRequestValue = crc.getHeaderString("Access-Control-Request-Headers");
            if ((accessControlRequestValue != null &&
                    (accessControlRequestValue.contains("authorization")
                            || accessControlRequestValue.contains("content-type")
                            || accessControlRequestValue.contains("georepo-appkey")))

                    // we need to be logged in for the real request!
                    || crc.getHeaderString("Authorization") != null

                    // these path' are allowed to be used with CORS
                    || crc.getUriInfo().getAbsolutePath().toString().endsWith("/register")) {

                // grs-204: allow cors credentials
                response.getHeaders().add("Access-Control-Allow-Credentials", true);
                if (crc.getHeaderString("Access-Control-Request-Headers") != null) {
                    response.getHeaders().add("Access-Control-Allow-Headers", accessControlRequestValue);
                }
                // grs-222: allow clients access narimosessid header
                response.getHeaders().add("Access-Control-Expose-Headers", "x-narimosessid");
            }
        }
    }
}
