//package de.narimo.georepo.server.internal;
//
//import java.awt.image.BufferedImage;
//import java.io.ByteArrayInputStream;
//import java.io.ByteArrayOutputStream;
//import java.io.IOException;
//import java.io.InputStream;
//
//import javax.imageio.ImageIO;
//import javax.servlet.ServletContext;
//import javax.ws.rs.Consumes;
//import javax.ws.rs.POST;
//import javax.ws.rs.Path;
//import javax.ws.rs.Produces;
//import javax.ws.rs.core.Context;
//import javax.ws.rs.core.MediaType;
//import javax.ws.rs.core.Response;
//import javax.ws.rs.core.SecurityContext;
//import javax.ws.rs.ext.Provider;
//
//import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
//import org.glassfish.jersey.media.multipart.FormDataParam;
//import org.marvinproject.image.transform.scale.Scale;
//
//import com.fasterxml.jackson.databind.ObjectMapper;
//
//import marvin.image.MarvinImage;
//
///**
// *
// * @author Ulrich Mann
// *
// */
//@Provider
//@Path("")
//public class GeorepoInternalAPI {
//
//    /**
//     * Get multiple thumbnails in different resolutions from an input image. Send
//     * format param as {"outputFormats" : [[32,32],[64,64]]}
//     * 
//     * @param sec
//     * @param ctx
//     * @param workspace
//     * @return
//     */
//    @POST
//    @Path("/builder/images/thumbnails")
//    @Consumes({ MediaType.MULTIPART_FORM_DATA })
//    @Produces("image/png")
//    public static Response getScaledImages(
//            @Context SecurityContext sec,
//            @Context ServletContext ctx,
//
//            @FormDataParam("formats") String scaleFormats,
//            @FormDataParam("file") InputStream uploadedInputStream,
//            @FormDataParam("file") FormDataContentDisposition fileDetail
//
//    ) {
//
//        BufferedImage bi = null;
//        byte[] imageData = null;
//        try {
//            ObjectMapper mapper = new ObjectMapper();
//            ImageScaleFormats formats = mapper.readValue(scaleFormats, ImageScaleFormats.class);
//
//            bi = ImageIO.read(uploadedInputStream);
//
//            int targetHeight = 100;
//            int targetWidth = 100;
//
//            if (formats != null) {
//                if (formats.getOutputFormats().size() < 1) {
//                    targetHeight = 100;
//                    float ratio = (float) bi.getWidth() / bi.getHeight();
//                    targetWidth = Math.round(targetHeight * ratio);
//                } else {
//                    targetHeight = formats.getOutputFormats().get(0)[0];
//                    targetWidth = formats.getOutputFormats().get(0)[1];
//                }
//            }
//
//            BufferedImage resizedImage = resizeImage(bi, targetWidth, targetHeight);
//
//            ByteArrayOutputStream baos = new ByteArrayOutputStream();
//            ImageIO.write(resizedImage, "png", baos);
//            imageData = baos.toByteArray();
//
//        } catch (IOException e) {
//            throw new InternalError("Could not resize image.", e);
//        }
//
//        return Response.ok(new ByteArrayInputStream(imageData)).build();
//    }
//
//    private static BufferedImage resizeImage(BufferedImage originalImage, int targetWidth, int targetHeight) {
//        MarvinImage image = new MarvinImage(originalImage);
//        Scale scale = new Scale();
//        scale.load();
//        scale.setAttribute("newWidth", targetWidth);
//        scale.setAttribute("newHeight", targetHeight);
//        scale.process(image.clone(), image, null, null, false);
//        return image.getBufferedImageNoAlpha();
//    }
//}
