package de.narimo.georepo.server.noauth;

import javax.ws.rs.NotFoundException;

public class RegistrationCheck {

    static void doCrawlerCheck(String useragent) {
        String userAgent = useragent.toLowerCase();
        if (userAgent.contains("bot") || userAgent.contains("crawl")) {
            throw new NotFoundException();
        }
    }

    public static void doEmailCheck(String email) throws IllegalArgumentException {
        if (email == null) {
            throw new IllegalArgumentException("Invalid email provided.");
        }

        if (!(email.contains("@") && email.contains("."))) {
            throw new IllegalArgumentException("Invalid email provided.");
        }

        try {
            email.split("@")[0].length();
            email.split("@")[1].length();
        } catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid email provided.");
        }

        if (email.split("@")[0].length() < 1 || email.split("@")[1].length() < 3) {
            throw new IllegalArgumentException("Invalid email provided.");
        }
    }
}
