package de.narimo.georepo.server.providers;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

import javax.imageio.ImageIO;

import de.narimo.georepo.server.GeorepoTools;

public class ImageScaler implements Runnable {

    private InputStream fileInputStream;
    private FileOutputStream fos = null;

    private static List<Img> icons0 = Arrays.asList(
            new Img("apple-icon-", 120, 120),
            new Img("apple-icon-", 152, 152),
            new Img("apple-icon-", 167, 167),
            new Img("apple-icon-", 180, 180),
            new Img("apple-launch-", 1125, 2436),
            new Img("apple-launch-", 1170, 2532),
            new Img("apple-launch-", 1242, 2208),
            new Img("apple-launch-", 1242, 2688),
            new Img("apple-launch-", 1284, 2778),
            new Img("apple-launch-", 1536, 2048),
            new Img("apple-launch-", 1620, 2160),
            new Img("apple-launch-", 1668, 2224),
            new Img("apple-launch-", 1668, 2388),
            new Img("apple-launch-", 2048, 2732),
            new Img("apple-launch-", 750, 1334),
            new Img("apple-launch-", 828, 1792),
            new Img("favicon-", 128, 128),
            new Img("favicon-", 16, 16),
            new Img("favicon-", 32, 32),
            new Img("favicon-", 512, 512),
            new Img("favicon-", 96, 96),
            new Img("icon-", 128, 128),
            new Img("icon-", 192, 192),
            new Img("icon-", 256, 256),
            new Img("icon-", 384, 384),
            new Img("icon-", 512, 512),
            new Img("ms-icon-", 144, 144));

    public ImageScaler(InputStream fileInputStream) throws IOException {
        if (fileInputStream == null) {
            throw new IOException("Input stream is null.");
        }
        this.fileInputStream = fileInputStream;
    }

    public void run() {

        String random = GeorepoTools.createAlphanumericString(12);
        File zipFile = new File("/home/ulrich/tmp/georepo-icons/georepo-icons-" + random + ".zip");

        try {

            // write the input stream to an initial file on the disk
            String basePath = "/home/ulrich/tmp/georepo-icons/georepo-icons-" + random;
            File originalImage = new File(basePath + "/input.png");
            originalImage.mkdirs();
            Files.copy(
                    fileInputStream,
                    originalImage.toPath(),
                    StandardCopyOption.REPLACE_EXISTING);

            fos = new FileOutputStream(zipFile);
            ZipOutputStream zos = new ZipOutputStream(fos);

            for (Img icon : icons0) {

                BufferedImage bi = ImageIO.read(new FileInputStream(originalImage));
                System.out.println("bi is " + bi);
                BufferedImage resizedBi = resizeImage(bi, icon.getWidth(), icon.getHeight());

                String iconName = icon.getName() + icon.getWidth() + "x" + icon.getHeight() + ".png";
                ZipEntry entry = new ZipEntry(iconName);

                zos.putNextEntry(entry);
                ImageIO.write(resizedBi, "png", zos);

                zos.closeEntry();
            }
            zos.flush();
            zos.close();

            Files.delete(originalImage.toPath());

        } catch (IOException ex) {
            System.out.println(ex);
            zipFile.delete();
        } finally {
            if (fos != null) {
                try {
                    fos.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static BufferedImage resizeImage(BufferedImage originalImage, int targetWidth, int targetHeight)
            throws IOException {
        Image resultingImage = originalImage.getScaledInstance(targetWidth, targetHeight, Image.SCALE_DEFAULT);
        BufferedImage outputImage = new BufferedImage(targetWidth, targetHeight, BufferedImage.TYPE_INT_ARGB);
        outputImage.getGraphics().drawImage(resultingImage, 0, 0, null);
        return outputImage;
    }

    public FileOutputStream getFos() { return fos; }

    public static void main(String[] args) throws IOException {

        File f = new File("/home/ulrich/Documents/projects/mhs/georepo-atlas/logo.png");
        FileInputStream fis = new FileInputStream(f);

        ImageScaler scaler = new ImageScaler(fis);
        scaler.run();

//        File outputfile = new File("/home/ulrich/tmp/georepo-icon-2048x2732-copy2.png");
//        ImageIO.write(resizeImage(ImageIO.read(f), 256, 256), "png", outputfile);

    }

}
