package de.narimo.georepo.server.pub;

import java.io.ByteArrayInputStream;

import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.ext.Provider;

import de.narimo.georepo.server.api.app.AppManifestConfiguration;
import de.narimo.georepo.server.appconfig.AppSettingsService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.servers.Server;
import io.swagger.v3.oas.annotations.tags.Tag;

@Provider
@Path("/apps")
@Tag(name = "AppResources")
@Server(url = "/georepo-server/public")
public class AppResourcesController {

    AppSettingsService settingsService = new AppSettingsService();

    @GET
    @Path("/{appkey}/icons/{iconname}")
    @Operation(summary = "Get an app icon")
    public Response getAppIcon(
            @Context ServletContext ctx,
            @PathParam("appkey") String appkey,
            @PathParam("iconname") String iconName) {

        try {
            System.out.println("iconname: " + iconName);
            byte[] fileData = settingsService.getAppIcon(ctx, appkey, iconName);
            return Response.ok().entity(new ByteArrayInputStream(fileData)).build();
        } catch (NotFoundException e) {
            e.printStackTrace();
            return Response.status(Status.NOT_FOUND).build();
        } catch (Exception e) {
            e.printStackTrace();
            return Response.status(Status.BAD_REQUEST).build();
        }
    }

    @GET
    @Path("/{appkey}/manifest")
    @Produces({ MediaType.APPLICATION_JSON })
    @Operation(summary = "Get the manifest of an app")
    public Response getAppManifest(
            @PathParam("appkey") String appKey) {

        try {
            AppManifestConfiguration manifestConfiguration = settingsService.getAppManifest(appKey);
            return Response.ok().entity(manifestConfiguration.getAppManifest()).build();
        } catch (NotFoundException e) {
            e.printStackTrace();
            return Response.status(Status.NOT_FOUND).build();
        } catch (Exception e) {
            e.printStackTrace();
            return Response.status(Status.BAD_REQUEST).build();
        }
    }
}
