package de.narimo.georepo.server.repository;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import de.narimo.commons.jdbc.JDBCConnectionJNDI;
import de.narimo.georepo.server.tools.TableTools;

public class InvoiceRepository {

    public static void createInvoicesTable() {
        JDBCConnectionJNDI jdbcAuth = null;
        String invTable = TableTools.getAppInvoicesTableName();

        try {
            jdbcAuth = new JDBCConnectionJNDI("jdbc/georepoAuthDatasource");

            if (ParentDatasetRepository.tableExists(jdbcAuth, "public", invTable)) {
                return;
            }

            String sql = "CREATE TABLE IF NOT EXISTS public." + invTable + " ("
                    + "id SERIAL UNIQUE NOT NULL,"
                    + "name text UNIQUE NOT NULL,"
                    + "invoiceid integer NOT NULL,"
                    + "appname text NOT NULL,"
                    + "appkey text NOT NULL,"
                    + "insertedat timestamp without time zone DEFAULT timezone('utc'::text, now()) NOT NULL,"
                    + "PRIMARY KEY (appname, invoiceid)"
                    + ");";

            System.out.println(sql);
            jdbcAuth.execute(sql);

        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        } finally {
            if (jdbcAuth != null) {
                jdbcAuth.closeAll();
                jdbcAuth = null;
            }
        }
    }

    /**
     * Reserves and returns the running invoice id counter. If the subsequent
     * invoicing process is failing, the written row MUST be removed from the table
     * to preserve the invoice id counter without missing values!
     * 
     * 
     * @param invoiceName
     * @return
     * @throws SQLException
     */
    public static int reserveInvoiceId(JDBCConnectionJNDI jdbcAuth, String appInvoicePattern, String appkey)
            throws SQLException {
        String invTable = TableTools.getAppInvoicesTableName();

        String sql = "INSERT INTO public." + invTable + " (invoiceid, name, appname, appkey) "
                + "VALUES((SELECT COUNT(*) FROM appinvoices WHERE appname = ?)+1,'pre-reserved', ?, ?) RETURNING invoiceid;";

        PreparedStatement ps = jdbcAuth.prepareStatement(sql);
        ps.setString(1, appInvoicePattern);
        ps.setString(2, appInvoicePattern);
        ps.setString(3, appkey);
        System.out.println(sql);

        ResultSet rs = jdbcAuth.executePreparedQuery(ps);
        if (rs.next()) {
            return rs.getInt("invoiceid");
        }
        throw new RuntimeException("Insert returned no resulting invoiceid.");
    }

    public static void updateInvoice(JDBCConnectionJNDI jdbcAuth, String invoiceName, int reservedInvoiceCounter,
            String appInvoicePattern)
            throws SQLException {

        String invTable = TableTools.getAppInvoicesTableName();
        String sql = "UPDATE " + invTable + " SET name = ? "
                + "WHERE appname = ? AND invoiceid = " + reservedInvoiceCounter + ";";

        PreparedStatement ps = jdbcAuth.prepareStatement(sql);
        ps.setString(1, invoiceName);
        ps.setString(2, appInvoicePattern);

        System.out.println(sql);
        jdbcAuth.executePreparedUpdate(ps);
    }

    public static void removeFailedInvoiceId(JDBCConnectionJNDI jdbcAuth, int reservedInvoiceCounter,
            String appInvoicePattern)
            throws SQLException {

        System.out.println("Removing apparently corrupt invoiceid " + reservedInvoiceCounter);

        String invTable = TableTools.getAppInvoicesTableName();
        String sql = "DELETE FROM " + invTable
                + " WHERE appname = ? AND invoiceid = " + reservedInvoiceCounter + ";";

        PreparedStatement ps = jdbcAuth.prepareStatement(sql);
        ps.setString(1, appInvoicePattern);

        System.out.println(sql);
        jdbcAuth.executePreparedUpdate(ps);
    }
}
