package de.narimo.georepo.server.tools;

import java.util.List;

import javax.ws.rs.ForbiddenException;

import de.narimo.commons.dto.User;
import de.narimo.geocore.ws.repository.UserRepository;
import de.narimo.georepo.server.api.workspaces.Workspace;
import de.narimo.georepo.server.repository.WorkspaceRepository;

public class AdminTools {

    /**
     * Check if user has admin permissions for the workspace.
     *
     * @throws ForbiddenException in case of missing admin permission for the
     *                            workspace
     */
    public static void checkAdminPermission(int userId, String workspace) throws ForbiddenException {
        Workspace ws = new Workspace();
        ws.setName(workspace);
        if (!isWorkspaceAdmin(userId, ws)) {
            throw new ForbiddenException("Unsufficient permissions for this operation.");
        }
    }

    public static boolean isWorkspaceAdmin(int userId, Workspace workspace) throws ForbiddenException {
        int workspaceCount = WorkspaceRepository.getWorkspaceCount(userId, workspace,
                WorkspacePermissions.adminPermission);
        if (workspaceCount < 1) {
            return false;
        }
        return true;
    }

    public static void checkCanCreateWorkspace(User user) throws ForbiddenException {
        if (!WorkspaceRepository.canUserCreateWorkspace(user)) {
            throw new ForbiddenException("No permissions to create workspace.");
        }
    }

    /**
     * Get users with admin permission on a given workspace and enabled in users
     * table.
     * 
     * @param workspace
     * @return
     */
    public static List<User> getAdminUsers(String workspace) {
        List<Integer> adminIds = WorkspaceRepository.getWorkspaceAdminIds(workspace);
        return UserRepository.getUsersById(adminIds);
    }
}
