package de.narimo.georepo.server.tools;

import java.util.Locale;
import java.util.ResourceBundle;

import de.narimo.commons.dto.RegistrationLanguage;

public class Translator {

    private ResourceBundle languageProperties_en_US;
    private ResourceBundle languageProperties_de_DE;
    private ResourceBundle languageProperties_es_ES;
    private ResourceBundle languageProperties_fr_FR;

    public Translator() {
        try {
            languageProperties_de_DE = ResourceBundle.getBundle("Translations", new Locale("de", "DE"));
            languageProperties_en_US = ResourceBundle.getBundle("Translations", new Locale("en", "US"));
            languageProperties_es_ES = ResourceBundle.getBundle("Translations", new Locale("es", "ES"));
            languageProperties_fr_FR = ResourceBundle.getBundle("Translations", new Locale("fr", "FR"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Translates a language key into the desired language. Returns en_US
     * translation, if the desired language code does not exist.
     * 
     * @param key
     * @param language
     * @param args
     * @return
     */
    public String translate(String key, RegistrationLanguage language, String... args) {
        return String.format(getTranslations(language).getString(key), (Object[]) args);
    }

    private ResourceBundle getTranslations(RegistrationLanguage language) {
        if (language == null) {
            return languageProperties_en_US;
        }
        switch (language) {
        case de_DE:
            return languageProperties_de_DE;
        case es_ES:
            return languageProperties_es_ES;
        case fr_FR:
            return languageProperties_fr_FR;
        default:
            return languageProperties_en_US;
        }
    }
}
