package de.narimo.georepo.server.tools;

import java.util.Arrays;
import java.util.List;

public class WorkspacePermissions {

    public static String noPermission = "none";
    public static String readPermission = "r";
    public static String writePermission = "rw";
    public static String adminPermission = "rwa";

    public static List<String> availablePermissions = Arrays.asList(
            noPermission,
            readPermission,
            writePermission,
            adminPermission
    );

    public static String getReadablePermission(String permissionType) {
        switch (permissionType) {
            case "r":
                return "read";
            case "rw":
                return "write";
            case "rwa":
                return "admin";
            default:
                return "none";
        }
    }
}
