/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.TransverseMercator;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class TransverseMercatorHandlerFactory
implements ProjectionHandlerFactory {
    @Override
    public ProjectionHandler getHandler(ReferencedEnvelope renderingEnvelope, CoordinateReferenceSystem sourceCrs, boolean wrap, int maxWraps) throws FactoryException {
        MapProjection mapProjection = CRS.getMapProjection((CoordinateReferenceSystem)renderingEnvelope.getCoordinateReferenceSystem());
        if (renderingEnvelope != null && mapProjection instanceof TransverseMercator) {
            double centralMeridian = mapProjection.getParameterValues().parameter(MapProjection.AbstractProvider.CENTRAL_MERIDIAN.getName().getCode()).doubleValue();
            ReferencedEnvelope validArea = new ReferencedEnvelope(centralMeridian - 45.0, centralMeridian + 45.0, -85.0, 85.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            ProjectionHandler ph = new ProjectionHandler(sourceCrs, validArea, renderingEnvelope);
            if (validArea.getMinX() < 180.0 && validArea.getMaxX() > 180.0 || validArea.getMinX() < -180.0 && validArea.getMaxX() > -180.0) {
                ph.computeDatelineX();
            }
            return ph;
        }
        return null;
    }
}

