/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.geotools.metadata.i18n.Errors;
import org.geotools.metadata.i18n.Loggings;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.BufferedAuthorityFactory;
import org.geotools.referencing.factory.FactoryNotFoundException;
import org.geotools.util.factory.Hints;
import org.geotools.util.factory.OptionalFactory;
import org.opengis.referencing.FactoryException;

public abstract class DeferredAuthorityFactory
extends BufferedAuthorityFactory
implements OptionalFactory {
    private static Timer TIMER = new Timer("GT authority factory disposer", true);
    private TimerTask disposer;
    private boolean used;

    protected DeferredAuthorityFactory(Hints userHints, int priority) {
        super(priority, 20);
    }

    protected DeferredAuthorityFactory(Hints userHints, int priority, int maxStrongReferences) {
        super(priority, maxStrongReferences);
    }

    @Override
    public boolean isAvailable() {
        return super.isAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final AbstractAuthorityFactory getBackingStore() throws FactoryException {
        if (this.backingStore == null) {
            DeferredAuthorityFactory deferredAuthorityFactory = this;
            synchronized (deferredAuthorityFactory) {
                if (this.backingStore == null) {
                    this.backingStore = this.createBackingStore();
                    if (this.backingStore == null) {
                        throw new FactoryNotFoundException(Errors.format((int)131));
                    }
                    this.completeHints();
                }
            }
        }
        this.used = true;
        return this.backingStore;
    }

    protected abstract AbstractAuthorityFactory createBackingStore() throws FactoryException;

    public synchronized boolean isConnected() {
        return this.backingStore != null;
    }

    public synchronized void setTimeout(long delay) {
        if (TIMER == null) {
            return;
        }
        if (this.disposer != null) {
            this.disposer.cancel();
        }
        this.disposer = new Disposer();
        TIMER.schedule(this.disposer, delay, delay);
    }

    protected boolean canDisposeBackingStore(AbstractAuthorityFactory backingStore) {
        return true;
    }

    @Override
    public synchronized void dispose() throws FactoryException {
        if (this.disposer != null) {
            this.disposer.cancel();
            this.disposer = null;
        }
        super.dispose();
    }

    public static void exit() {
        if (TIMER != null) {
            TIMER.cancel();
            TIMER = null;
        }
    }

    protected synchronized void disposeBackingStore() {
        try {
            if (this.backingStore != null) {
                LOGGER.log(Level.INFO, "Disposing " + ((Object)((Object)this)).getClass() + " backing store");
                this.backingStore.dispose();
                this.backingStore = null;
            }
        }
        catch (FactoryException exception) {
            this.backingStore = null;
            LogRecord record = Loggings.format((Level)Level.WARNING, (int)7);
            record.setSourceMethodName("run");
            record.setSourceClassName(Disposer.class.getName());
            record.setThrown(exception);
            record.setLoggerName(LOGGER.getName());
            LOGGER.log(record);
        }
    }

    private final class Disposer
    extends TimerTask {
        private Disposer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DeferredAuthorityFactory deferredAuthorityFactory = DeferredAuthorityFactory.this;
            synchronized (deferredAuthorityFactory) {
                if (DeferredAuthorityFactory.this.used || !DeferredAuthorityFactory.this.canDisposeBackingStore(DeferredAuthorityFactory.this.backingStore)) {
                    DeferredAuthorityFactory.this.used = false;
                    return;
                }
                if (this.cancel()) {
                    DeferredAuthorityFactory.this.disposer = null;
                    if (DeferredAuthorityFactory.this.backingStore != null) {
                        DeferredAuthorityFactory.this.disposeBackingStore();
                    }
                    DeferredAuthorityFactory.this.hints.remove(Hints.DATUM_AUTHORITY_FACTORY);
                    DeferredAuthorityFactory.this.hints.remove(Hints.CS_AUTHORITY_FACTORY);
                    DeferredAuthorityFactory.this.hints.remove(Hints.CRS_AUTHORITY_FACTORY);
                    DeferredAuthorityFactory.this.hints.remove(Hints.COORDINATE_OPERATION_AUTHORITY_FACTORY);
                }
            }
        }
    }
}

