/*
 * Decompiled with CFR 0.152.
 */
package de.narimo.commons.ws.filter;

import de.narimo.commons.ws.error.BadGatewayException;
import de.narimo.commons.ws.error.ErrorMessage;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.AccessDeniedException;
import javax.naming.AuthenticationException;
import javax.naming.NameNotFoundException;
import javax.naming.OperationNotSupportedException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;

public class GenericExceptionMapper
implements ExceptionMapper<Throwable> {
    public Response toResponse(Throwable ex) {
        System.out.println("GEM called with exception " + ex.getClass().getName());
        ErrorMessage errorMessage = new ErrorMessage();
        errorMessage.setStatus(this.getHttpStatus(ex));
        errorMessage.setMessage(ex.getMessage());
        StringWriter errorStackTrace = new StringWriter();
        ex.printStackTrace(new PrintWriter(errorStackTrace));
        ex.printStackTrace();
        return Response.status((int)errorMessage.getStatus()).entity((Object)errorMessage).type("application/json").build();
    }

    private int getHttpStatus(Throwable ex) {
        if (ex instanceof AuthenticationException) {
            return Response.Status.UNAUTHORIZED.getStatusCode();
        }
        if (ex instanceof ForbiddenException) {
            return ((ForbiddenException)ex).getResponse().getStatus();
        }
        if (ex instanceof AccessDeniedException) {
            return Response.Status.FORBIDDEN.getStatusCode();
        }
        if (ex instanceof NameNotFoundException) {
            return Response.Status.NOT_FOUND.getStatusCode();
        }
        if (ex instanceof WebApplicationException) {
            return ((WebApplicationException)ex).getResponse().getStatus();
        }
        if (ex instanceof OperationNotSupportedException) {
            return Response.Status.NOT_IMPLEMENTED.getStatusCode();
        }
        if (ex instanceof IllegalArgumentException) {
            return Response.Status.BAD_REQUEST.getStatusCode();
        }
        if (ex instanceof BadGatewayException) {
            return ((BadGatewayException)((Object)ex)).getResponse().getStatus();
        }
        if (ex instanceof InternalError) {
            return Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
        }
        return Response.Status.BAD_REQUEST.getStatusCode();
    }
}

