/*
 * Decompiled with CFR 0.152.
 */
package de.narimo.commons.ws.geocode;

import com.csvreader.CsvReader;
import com.csvreader.CsvWriter;
import de.narimo.commons.Point;
import de.narimo.commons.http.URLResponse;
import de.narimo.commons.json.JsonConverter;
import de.narimo.commons.ws.geocode.GeocodingGeometry;
import de.narimo.commons.ws.geocode.GeocodingResponse;
import de.narimo.commons.ws.http.HttpMethod;
import de.narimo.commons.ws.http.HttpURLClient;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;

public class Geocoder {
    public static Point geocode(String place, String postcode, String street, String housenr, String countryCode, String geocodeUrl, String apiKey) throws Exception {
        if (geocodeUrl == null) {
            geocodeUrl = "https://api.opencagedata.com/geocode/v1/json/";
        }
        String qString = street + ", " + housenr + ", " + postcode + ", " + place;
        if (countryCode.equals("de") || countryCode.equals("DE")) {
            qString = qString + ", Deutschland";
        }
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("q", qString);
        queryParams.put("countrycode", countryCode);
        queryParams.put("limit", "1");
        queryParams.put("no_record", "1");
        queryParams.put("key", apiKey);
        URLResponse rr = HttpURLClient.sendRequest(geocodeUrl, queryParams, null, null, HttpMethod.GET, null, null, null, true, false);
        if (rr.getStatusCode() != 200) {
            throw new RuntimeException("Geocoding operation returned non-ok status code " + rr.getStatusCode() + ".");
        }
        String response = rr.getResponseBody();
        GeocodingResponse gcResponse = (GeocodingResponse)JsonConverter.fromJson((String)response, GeocodingResponse.class);
        if (gcResponse.getTotalResults() == 0) {
            return null;
        }
        GeocodingGeometry g = gcResponse.getResults().get(0).getGeometry();
        Point p = new Point();
        p.setLatitude(g.getLatitude().doubleValue());
        p.setLongitude(g.getLongitude().doubleValue());
        System.out.println("Geocoding operations left: " + gcResponse.getRate().getRemaining());
        return p;
    }

    public static void geocodeCSVAddresses(File csvFile, File outputFile, int placeIndex, int postcodeIndex, int streetIndex, int housenrIndex, char sep, String countryCode, String geocodeUrl, String apiKey) throws Exception {
        CsvReader r = null;
        CsvWriter w = null;
        try {
            r = new CsvReader(csvFile.getAbsolutePath(), sep, StandardCharsets.UTF_8);
            r.readHeaders();
            w = new CsvWriter((Writer)new FileWriter(outputFile, false), sep);
            String[] headers = r.getHeaders();
            for (int i = 0; i < headers.length; ++i) {
                w.write(headers[i]);
            }
            w.write("latitude");
            w.write("longitude");
            w.endRecord();
            int cnt = 0;
            while (r.readRecord()) {
                Thread.sleep(1050L);
                String place = "";
                String postcode = "";
                String street = "";
                String house = "";
                String[] values = r.getValues();
                for (int i = 0; i < values.length; ++i) {
                    if (i == placeIndex) {
                        place = values[i];
                    }
                    if (i == postcodeIndex) {
                        postcode = values[i];
                    }
                    if (i == streetIndex) {
                        street = values[i];
                    }
                    if (i == housenrIndex) {
                        house = values[i];
                    }
                    w.write(values[i]);
                }
                Point p = Geocoder.geocode(place, postcode, street, house, countryCode, geocodeUrl, apiKey);
                if (p == null) {
                    return;
                }
                w.write("" + p.getLatitude());
                w.write("" + p.getLongitude());
                w.endRecord();
                if (cnt % 50 != 0) continue;
                w.flush();
            }
            w.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            w.close();
            r.close();
        }
    }

    public static void main(String[] args) throws Exception {
        File csvFile = new File("G:\\narimo\\Geschaeft\\Datenprodukte\\Krankenhaeuser\\qb-processed\\qb2015_all_java.csv");
        String filename = csvFile.getName().split(".csv")[0];
        File outputFile = new File(csvFile.getParent(), filename + "_georeferenced.csv");
        System.out.println("outfile: " + outputFile);
        String countryCode = "DE";
        String geocodeUrl = "https://api.opencagedata.com/geocode/v1/json/";
        String apiKey = "038acc4412ae48ccb67023b379e478ed";
        Geocoder.geocodeCSVAddresses(csvFile, outputFile, 7, 6, 4, 5, ';', countryCode, geocodeUrl, apiKey);
    }
}

