/*
 * Decompiled with CFR 0.152.
 */
package de.narimo.commons.ws.http;

import de.narimo.commons.UserCredentials;
import de.narimo.commons.http.URLResponse;
import de.narimo.commons.ws.http.CookieTools;
import de.narimo.commons.ws.http.HttpMethod;
import de.narimo.commons.ws.http.auth.HTTPAuthorizationFactory;
import de.narimo.commons.ws.http.auth.HTTPBasicAuthorizationFactory;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.bind.DatatypeConverter;

public class HttpURLClient {
    private Map<String, String> headers;
    private boolean https = false;
    private String user;
    private String pass;
    private URL obj;
    private boolean responseAsStream = false;
    private Boolean followRedirects = null;
    private SSLSocketFactory sslSocketFactory;
    private HostnameVerifier hostnameVerifier;
    private boolean verbose = false;

    public HttpURLClient(Map<String, String> headers, String user, String pass) {
        this.headers = headers;
        this.user = user;
        this.pass = pass;
    }

    public void setHttps(boolean https) {
        this.https = https;
    }

    public void setHttps(boolean https, SSLSocketFactory optSSLFactory, HostnameVerifier optHostnameVerifier) {
        this.https = https;
        this.sslSocketFactory = optSSLFactory;
        this.hostnameVerifier = optHostnameVerifier;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    private URLResponse get(String url) throws IOException {
        System.out.println("\nSending 'GET' request to URL : " + url);
        this.obj = new URL(url);
        HttpURLConnection con = null;
        if (this.https) {
            System.out.println("Setting up https connection.");
            System.setProperty("https.protocols", "TLSv1,TLSv1.1,TLSv1.2");
            con = (HttpsURLConnection)this.obj.openConnection();
            if (this.sslSocketFactory != null) {
                ((HttpsURLConnection)con).setSSLSocketFactory(this.sslSocketFactory);
                if (this.hostnameVerifier != null) {
                    ((HttpsURLConnection)con).setHostnameVerifier(this.hostnameVerifier);
                }
            }
        } else {
            System.out.println("Setting up http connection.");
            con = (HttpURLConnection)this.obj.openConnection();
        }
        if (this.followRedirects != null) {
            con.setInstanceFollowRedirects(false);
        }
        con.setRequestMethod("GET");
        if (this.headers != null) {
            for (String key : this.headers.keySet()) {
                con.addRequestProperty(key, this.headers.get(key));
                if (!this.verbose) continue;
                System.out.println("Header: " + key + "=" + this.headers.get(key));
            }
        }
        if (this.user != null) {
            String userpass = this.user + ":" + this.pass;
            String basicAuth = "Basic " + DatatypeConverter.printBase64Binary((byte[])userpass.getBytes());
            con.setRequestProperty("Authorization", basicAuth);
        }
        System.out.println("with credentials: " + this.user + " | pass?=" + (this.pass != null ? "yes" : "no"));
        if (this.verbose) {
            System.out.println("Response as stream?: " + this.responseAsStream);
        }
        StringBuffer responseBody = new StringBuffer();
        if (!this.responseAsStream) {
            responseBody = HttpURLClient.getResponseBody(con);
        }
        URLResponse response = HttpURLClient.makeResponse(con, responseBody, this.responseAsStream);
        if (this.followRedirects != null && this.followRedirects.booleanValue()) {
            response = this.followRedirects(response, HttpMethod.GET);
        }
        return response;
    }

    private URLResponse options(String url) throws IOException {
        System.out.println("\nSending 'OPTIONS' request to URL : " + url);
        this.obj = new URL(url);
        HttpURLConnection con = null;
        if (this.https) {
            System.out.println("Setting up https connection.");
            System.setProperty("https.protocols", "TLSv1,TLSv1.1,TLSv1.2");
            con = (HttpsURLConnection)this.obj.openConnection();
            if (this.sslSocketFactory != null) {
                ((HttpsURLConnection)con).setSSLSocketFactory(this.sslSocketFactory);
                if (this.hostnameVerifier != null) {
                    ((HttpsURLConnection)con).setHostnameVerifier(this.hostnameVerifier);
                }
            }
        } else {
            System.out.println("Setting up http connection.");
            con = (HttpURLConnection)this.obj.openConnection();
        }
        if (this.followRedirects != null) {
            con.setInstanceFollowRedirects(false);
        }
        con.setRequestMethod("OPTIONS");
        if (this.headers != null) {
            for (String key : this.headers.keySet()) {
                con.addRequestProperty(key, this.headers.get(key));
                if (!this.verbose) continue;
                System.out.println("Header: " + key + "=" + this.headers.get(key));
            }
        }
        if (this.verbose) {
            System.out.println("Response as stream?: " + this.responseAsStream);
        }
        StringBuffer responseBody = new StringBuffer();
        if (!this.responseAsStream) {
            responseBody = HttpURLClient.getResponseBody(con);
        }
        URLResponse response = HttpURLClient.makeResponse(con, responseBody, this.responseAsStream);
        if (this.followRedirects != null && this.followRedirects.booleanValue()) {
            response = this.followRedirects(response, HttpMethod.OPTIONS);
        }
        return response;
    }

    private URLResponse followRedirects(URLResponse response, HttpMethod method) throws IOException {
        int statusCode = response.getStatusCode();
        int maxRedirects = 5;
        int redirects = 0;
        while (statusCode == 301 || statusCode == 302) {
            if (redirects >= maxRedirects) {
                throw new IllegalArgumentException("Max HTTP redirects count of " + maxRedirects + " has been exceeded. Cannot follow redirect.");
            }
            ++redirects;
            Cookie[] cookies = null;
            try {
                System.out.println("Response cookie header: " + response.getResponseHeaders().get("Set-Cookie"));
                List responseCookies = (List)response.getResponseHeaders().get("Set-Cookie");
                cookies = CookieTools.getCookies(responseCookies);
                if (cookies != null) {
                    if (this.headers == null) {
                        this.headers = new HashMap<String, String>();
                    }
                    this.headers.put("Cookie", CookieTools.toCookieString(cookies));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String url = null;
            try {
                String location = (String)((List)response.getResponseHeaders().get("Location")).get(0);
                if (this.obj == null) {
                    throw new IllegalStateException("Requested URL unknown.");
                }
                URI resolvedLocationURI = this.obj.toURI().resolve(location);
                url = resolvedLocationURI.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            HTTPAuthorizationFactory factory = new HTTPAuthorizationFactory();
            UserCredentials cred = new UserCredentials();
            if (this.user != null && this.pass != null && (url.startsWith("https://") || url.startsWith("http://localhost/"))) {
                cred.setUserCredentials(this.user, this.pass);
                factory.setCredentials(cred);
            }
            if (cookies != null && cookies[0] != null) {
                factory.setSessionCookies(cookies);
            }
            System.out.println("Redirect to: " + url);
            if (method.equals((Object)HttpMethod.GET)) {
                response = this.postOrPut0(method.toString(), url, null);
            } else if (method.equals((Object)HttpMethod.POST) || method.equals((Object)HttpMethod.PUT)) {
                response = this.postOrPut0(method.toString(), url, null);
            } else if (method.equals((Object)HttpMethod.OPTIONS)) {
                response = this.options(url);
            }
            statusCode = response.getStatusCode();
        }
        return response;
    }

    private URLResponse put(String url, String entity) throws IOException {
        System.out.println("\nSending 'PUT' request to URL : " + url);
        return this.postOrPut0("PUT", url, entity);
    }

    private URLResponse post(String url, String entity) throws IOException {
        System.out.println("\nSending 'POST' request to URL : " + url);
        return this.postOrPut0("POST", url, entity);
    }

    private URLResponse postOrPut0(String method, String url, String entity) throws IOException {
        HttpURLConnection con;
        block12: {
            this.obj = new URL(url);
            con = null;
            if (this.https) {
                System.setProperty("https.protocols", "TLSv1,TLSv1.1,TLSv1.2");
                con = (HttpsURLConnection)this.obj.openConnection();
            } else {
                con = (HttpURLConnection)this.obj.openConnection();
            }
            if (this.followRedirects != null) {
                con.setInstanceFollowRedirects(false);
            }
            con.setRequestMethod(method);
            if (this.headers != null) {
                for (String key : this.headers.keySet()) {
                    con.addRequestProperty(key, this.headers.get(key));
                    if (!this.verbose) continue;
                    System.out.println("adding header to request: " + key + "=" + this.headers.get(key));
                }
            }
            if (this.user != null) {
                String userpass = this.user + ":" + this.pass;
                String basicAuth = "Basic " + DatatypeConverter.printBase64Binary((byte[])userpass.getBytes());
                con.setRequestProperty("Authorization", basicAuth);
            }
            System.out.println("with credentials: " + this.user + " | pass?=" + (this.pass != null ? "yes" : "no"));
            FilterOutputStream wr = null;
            try {
                if (entity != null) {
                    con.addRequestProperty("Content-Length", String.valueOf(entity.getBytes("UTF-8").length));
                    con.setDoOutput(true);
                    wr = new DataOutputStream(con.getOutputStream());
                    wr.write(entity.getBytes("UTF-8"));
                    ((DataOutputStream)wr).flush();
                } else {
                    con.addRequestProperty("Content-Length", "0");
                }
            }
            catch (Exception e) {
                if (wr == null) break block12;
                wr.close();
            }
        }
        System.out.println("Response as stream?: " + this.responseAsStream);
        StringBuffer responseBody = new StringBuffer();
        if (!this.responseAsStream) {
            responseBody = HttpURLClient.getResponseBody(con);
        }
        URLResponse response = HttpURLClient.makeResponse(con, responseBody, this.responseAsStream);
        if (this.followRedirects != null && this.followRedirects.booleanValue()) {
            response = this.followRedirects(response, method.equals("PUT") ? HttpMethod.PUT : HttpMethod.POST);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer getResponseBody(HttpURLConnection con) throws IOException {
        StringBuffer responseBody = new StringBuffer();
        try (BufferedReader in = null;){
            String inputLine;
            in = new BufferedReader(new InputStreamReader(con.getInputStream(), "UTF-8"));
            while ((inputLine = in.readLine()) != null) {
                responseBody.append(inputLine);
            }
        }
        return responseBody;
    }

    public static URLResponse makeResponse(HttpURLConnection con, StringBuffer responseBody, boolean responseAsStream) throws IOException {
        int responseCode = con.getResponseCode();
        System.out.println("Response Code : " + responseCode);
        URLResponse response = new URLResponse();
        try {
            Map<String, List<String>> responseHeaders = con.getHeaderFields();
            response.setResponseHeaders(responseHeaders);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (responseAsStream) {
                response.setResponseStream(con.getInputStream());
            } else {
                response.setResponseBody(responseBody.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        response.setStatusCode(responseCode);
        return response;
    }

    public static URLResponse sendRequest(String wsUrl, Map<String, String> queryParams, Map<String, String> connectionHeaders, String body, HttpMethod method, Cookie[] cookies, String user, String pass, boolean https, boolean responseAsStream) throws IOException {
        MultivaluedHashMap queryParamsMulti = null;
        if (queryParams != null) {
            queryParamsMulti = new MultivaluedHashMap();
            for (String key : queryParams.keySet()) {
                queryParamsMulti.put((Object)key, Arrays.asList(queryParams.get(key)));
            }
        }
        return HttpURLClient.sendRequest0(wsUrl, (MultivaluedMap<String, String>)queryParamsMulti, connectionHeaders, body, method, cookies, user, pass, https, responseAsStream, null, null, null);
    }

    public static URLResponse sendRequest(String wsUrl, Map<String, String> queryParams, Map<String, String> connectionHeaders, String body, HttpMethod method, HTTPBasicAuthorizationFactory authFactory, boolean https, boolean responseAsStream) throws Exception {
        String user = null;
        String pass = null;
        Cookie[] cookies = null;
        if (authFactory != null) {
            user = authFactory.getCredentials() == null ? null : authFactory.getCredentials().getUsername();
            pass = authFactory.getCredentials() == null ? null : authFactory.getCredentials().getPassword();
            cookies = authFactory.getSessionCookies();
        }
        MultivaluedHashMap queryParamsMulti = null;
        if (queryParams != null) {
            queryParamsMulti = new MultivaluedHashMap();
            for (String key : queryParams.keySet()) {
                queryParamsMulti.put((Object)key, Arrays.asList(queryParams.get(key)));
            }
        }
        return HttpURLClient.sendRequest0(wsUrl, (MultivaluedMap<String, String>)queryParamsMulti, connectionHeaders, body, method, cookies, user, pass, https, responseAsStream, null, null, null);
    }

    public static URLResponse sendRequest(String wsUrl, Map<String, String> queryParams, Map<String, String> connectionHeaders, String body, HttpMethod method, HTTPAuthorizationFactory authFactory, boolean https, boolean responseAsStream, boolean followRedirects) throws Exception {
        String user = null;
        String pass = null;
        MultivaluedHashMap queryParamsMulti = null;
        if (authFactory != null) {
            user = authFactory.getCredentials() == null ? null : authFactory.getCredentials().getUsername();
            String string = pass = authFactory.getCredentials() == null ? null : authFactory.getCredentials().getPassword();
        }
        if (queryParams != null) {
            queryParamsMulti = new MultivaluedHashMap();
            for (String key : queryParams.keySet()) {
                queryParamsMulti.put((Object)key, Arrays.asList(queryParams.get(key)));
            }
        }
        return HttpURLClient.sendRequest0(wsUrl, (MultivaluedMap<String, String>)queryParamsMulti, connectionHeaders, body, method, authFactory == null ? null : authFactory.getSessionCookies(), user, pass, https, responseAsStream, followRedirects, null, null);
    }

    public static URLResponse sendRequestMultivalue(String wsUrl, MultivaluedMap<String, String> queryParams, Map<String, String> connectionHeaders, String body, HttpMethod method, HTTPBasicAuthorizationFactory authFactory, boolean https, boolean responseAsStream, boolean followRedirects) throws Exception {
        String user = null;
        String pass = null;
        Cookie[] cookies = null;
        if (authFactory != null) {
            user = authFactory.getCredentials() == null ? null : authFactory.getCredentials().getUsername();
            pass = authFactory.getCredentials() == null ? null : authFactory.getCredentials().getPassword();
            cookies = authFactory.getSessionCookies();
        }
        return HttpURLClient.sendRequest0(wsUrl, queryParams, connectionHeaders, body, method, cookies, user, pass, https, responseAsStream, followRedirects, null, null);
    }

    private static URLResponse sendRequest0(String wsUrl, MultivaluedMap<String, String> queryParams, Map<String, String> connectionHeaders, String body, HttpMethod method, Cookie[] cookies, String user, String pass, boolean https, boolean responseAsStream, Boolean followRedirects, SSLSocketFactory optSSLSocketFactory, HostnameVerifier optHostnameVerifier) throws IOException {
        URLResponse rr = null;
        if (cookies != null) {
            if (connectionHeaders == null) {
                connectionHeaders = new HashMap<String, String>();
            }
            connectionHeaders.put("Cookie", CookieTools.toCookieString(cookies));
        }
        HttpURLClient httpConn = new HttpURLClient(connectionHeaders, user, pass);
        if (queryParams != null) {
            if (!wsUrl.endsWith("?")) {
                wsUrl = wsUrl + "?";
            }
            for (String key : queryParams.keySet()) {
                if (key == null) continue;
                for (String value : (List)queryParams.get((Object)key)) {
                    if (value == null) continue;
                    wsUrl = wsUrl + "&" + URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(value, "UTF-8");
                }
            }
        }
        httpConn.setHttps(https, optSSLSocketFactory, optHostnameVerifier);
        httpConn.setResponseAsStream(responseAsStream);
        if (followRedirects != null) {
            httpConn.setFollowRedirects(followRedirects);
        }
        if (method == HttpMethod.GET) {
            rr = httpConn.get(wsUrl);
        } else if (method == HttpMethod.POST) {
            rr = httpConn.post(wsUrl, body);
        } else if (method == HttpMethod.PUT) {
            rr = httpConn.put(wsUrl, body);
        } else if (method == HttpMethod.OPTIONS) {
            rr = httpConn.options(wsUrl);
        } else {
            throw new IOException("Connection method " + (Object)((Object)method) + " not supported.");
        }
        return rr;
    }

    public void setResponseAsStream(boolean responseAsStream) {
        this.responseAsStream = responseAsStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringFromInputStream(InputStream is) {
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public static SSLSocketFactory getSSLSocketFactoryTrusted() throws Exception {
        SSLContext sc = SSLContext.getInstance("SSL");
        X509TrustManager tm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        sc.init(null, new TrustManager[]{tm}, null);
        SSLSocketFactory sf = sc.getSocketFactory();
        return sf;
    }

    public static Verifier getHostnameVerifier() {
        return new Verifier();
    }

    public static void main(String[] args) throws URISyntaxException, MalformedURLException {
        URL url = new URL("http://localhost:8080/test");
        String gnPath = url.getPath();
        System.out.println("path: " + gnPath);
    }

    public static class Verifier
    implements HostnameVerifier {
        @Override
        public boolean verify(String arg0, SSLSession arg1) {
            return true;
        }
    }
}

