/*
 * Decompiled with CFR 0.152.
 */
package de.narimo.commons.ws.http;

import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Cookie;

public class CookieTools {
    public static Cookie getCookie(String cookieString, String cookieName) {
        List<HttpCookie> cookies = HttpCookie.parse(cookieString);
        for (HttpCookie c : cookies) {
            if (!c.getName().equals(cookieName)) continue;
            return new Cookie(c.getName(), c.getValue(), c.getPath(), c.getDomain());
        }
        return null;
    }

    public static Cookie getCookie(List<String> cookieStrings, String cookieName) {
        if (cookieStrings == null) {
            return null;
        }
        for (String cookieString : cookieStrings) {
            List<HttpCookie> cookies = HttpCookie.parse(cookieString);
            for (HttpCookie c : cookies) {
                if (!c.getName().equals(cookieName)) continue;
                return new Cookie(c.getName(), c.getValue(), c.getPath(), c.getDomain());
            }
        }
        return null;
    }

    public static Cookie[] getCookies(List<String> cookieStrings) {
        if (cookieStrings == null) {
            return null;
        }
        ArrayList<Cookie> cookiesList = new ArrayList<Cookie>();
        for (String cookieString : cookieStrings) {
            List<HttpCookie> cookies = HttpCookie.parse(cookieString);
            for (HttpCookie c : cookies) {
                cookiesList.add(new Cookie(c.getName(), c.getValue(), c.getPath(), c.getDomain()));
            }
        }
        Cookie[] cookiesListDummy = new Cookie[cookiesList.size()];
        return cookiesList.toArray(cookiesListDummy);
    }

    public static Cookie getCookie(Cookie[] cookies, String cookieName) {
        if (cookies == null) {
            return null;
        }
        for (Cookie c : cookies) {
            if (!c.getName().equals(cookieName)) continue;
            return c;
        }
        return null;
    }

    public static String getCookieValue(String cookieString, String cookieName) {
        List<HttpCookie> cookies = HttpCookie.parse(cookieString);
        for (HttpCookie c : cookies) {
            if (!c.getName().equals(cookieName)) continue;
            return c.getValue();
        }
        return null;
    }

    public static String getCookieValue(List<String> cookieStrings, String cookieName) {
        for (String cookieString : cookieStrings) {
            List<HttpCookie> cookies = HttpCookie.parse(cookieString);
            for (HttpCookie c : cookies) {
                if (!c.getName().equals(cookieName)) continue;
                return c.getValue();
            }
        }
        return null;
    }

    public static String toCookieString(Cookie[] cookies) {
        String cookieString = "";
        int i = 0;
        for (Cookie co : cookies) {
            if (i > 0) {
                cookieString = cookieString + "; ";
            }
            cookieString = cookieString + co.getName() + "=" + co.getValue();
            ++i;
        }
        return cookieString;
    }
}

