/*
 * Decompiled with CFR 0.152.
 */
package de.narimo.commons.ws.filter;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import javax.annotation.Priority;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;

@Provider
@Priority(value=5000)
public class RequestLogger
implements ContainerRequestFilter {
    @Context
    private HttpServletRequest httpServletRequest;
    @Context
    private ServletContext ctx;

    public void filter(ContainerRequestContext crc) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Date dt = new Date();
        String time = sdf.format(dt);
        if (this.ctx.getInitParameter("GEOMETA_GEOREPO_DEBUG").equals("MINIMAL")) {
            RequestLogger.printRequestURL(time, this.httpServletRequest);
        } else if (this.ctx.getInitParameter("GEOMETA_GEOREPO_DEBUG").equals("COMPLETE")) {
            RequestLogger.printRequestURL(time, this.httpServletRequest);
            RequestLogger.printRequestHeaders(time, this.httpServletRequest);
        }
    }

    private static void printRequestURL(String timestamp, HttpServletRequest httpServletRequest) {
        System.out.println("\nIncoming request [" + timestamp + "]: \n" + httpServletRequest.getMethod() + " " + httpServletRequest.getRequestURL() + "?" + (httpServletRequest.getQueryString() != null ? httpServletRequest.getQueryString() : ""));
    }

    public static void printRequestHeaders(String timestamp, HttpServletRequest httpServletRequest) {
        System.out.println("\nIncoming request headers [" + timestamp + "]: \n");
        Enumeration headerNames = httpServletRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String header = (String)headerNames.nextElement();
            String value = httpServletRequest.getHeader(header);
            System.out.println("\t" + header + ": " + value);
        }
    }
}

