/*
 * Decompiled with CFR 0.152.
 */
package de.narimo.commons.ws.http;

import de.narimo.commons.http.URLResponse;
import de.narimo.commons.ws.http.HTTPRequestParams;
import de.narimo.commons.ws.http.HTTPRequestWrapper;
import de.narimo.commons.ws.http.HttpMethod;
import de.narimo.commons.ws.http.HttpURLClient;
import de.narimo.commons.ws.http.auth.HTTPBasicAuthorizationFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

public class HTTPProxy {
    public static Response pipeServiceRequest(String remoteWMSUrl, HttpMethod method, MultivaluedMap<String, String> queryParams, Map<String, String> headers, String body, HTTPBasicAuthorizationFactory authFactory, boolean followRedirects) throws Exception {
        return HTTPProxy.pipeServiceRequest(remoteWMSUrl, method, queryParams, headers, body, authFactory, followRedirects, false);
    }

    private static Response pipeServiceRequest(String remoteWMSUrl, HttpMethod method, MultivaluedMap<String, String> queryParams, Map<String, String> headers, String body, HTTPBasicAuthorizationFactory authFactory, boolean followRedirects, boolean fix401) throws Exception {
        boolean responseAsStream = true;
        URLResponse response = HttpURLClient.sendRequestMultivalue(remoteWMSUrl, queryParams, headers, body, method, authFactory, false, responseAsStream, followRedirects);
        Map<String, List<String>> outputHeaders = HTTPProxy.pipeOutgoingHeaders(null, response.getResponseHeaders(), true);
        response.setResponseHeaders(outputHeaders);
        Response r = HTTPProxy.finish(response, responseAsStream, fix401);
        HTTPProxy.removeHeader((MultivaluedMap<String, String>)r.getStringHeaders(), "Transfer-Encoding");
        return r;
    }

    public static Response pipeServiceRequest(HTTPRequestParams params, boolean toExternal, boolean fix401) throws Exception {
        boolean responseAsStream = true;
        params.setResponseAsStream(responseAsStream);
        URLResponse response = HTTPRequestWrapper.sendRequest(params, toExternal);
        Map<String, List<String>> outputHeaders = HTTPProxy.pipeOutgoingHeaders(null, response.getResponseHeaders(), true);
        response.setResponseHeaders(outputHeaders);
        Response r = HTTPProxy.finish(response, responseAsStream, fix401);
        HTTPProxy.removeHeader((MultivaluedMap<String, String>)r.getStringHeaders(), "Transfer-Encoding");
        return r;
    }

    public static Response finish(URLResponse response, boolean responseAsStream) throws Exception {
        return HTTPProxy.finish0(response, responseAsStream, response.getStatusCode());
    }

    public static Response finish(URLResponse response, boolean responseAsStream, boolean fix401) throws Exception {
        int statusCode = response.getStatusCode();
        if (fix401 && statusCode == 401) {
            statusCode = 4010;
        }
        return HTTPProxy.finish0(response, responseAsStream, statusCode);
    }

    private static Response finish0(URLResponse response, boolean responseAsStream, int statusCode) throws Exception {
        Response.ResponseBuilder rb = Response.status((int)statusCode).entity(responseAsStream ? response.getResponseStream() : response.getResponseBody());
        HTTPProxy.pipeHeaders(rb, response.getResponseHeaders());
        return rb.build();
    }

    static void pipeHeaders(Response.ResponseBuilder rb, Map<String, List<String>> inputHeaders) {
        for (String header : inputHeaders.keySet()) {
            if (header == null) continue;
            String headerValue = "";
            int cnt = 0;
            for (String value : inputHeaders.get(header)) {
                if (cnt > 0) {
                    headerValue = headerValue + "; ";
                }
                headerValue = headerValue + value;
                ++cnt;
            }
            rb.header(header, (Object)headerValue);
        }
    }

    public static void removeHeader(MultivaluedMap<String, String> inputHeaders, String omit) {
        Iterator iter = inputHeaders.keySet().iterator();
        while (iter.hasNext()) {
            if (!((String)iter.next()).toLowerCase().equals(omit.toLowerCase())) continue;
            iter.remove();
        }
    }

    public static void checkHeaders(MultivaluedMap<String, String> inputHeaders) {
        for (String string : inputHeaders.keySet()) {
        }
    }

    public static MultivaluedMap<String, String> setHeader(MultivaluedMap<String, String> inputHeaders, String headerKey, String headerValue) {
        HTTPProxy.removeHeader(inputHeaders, headerKey);
        MultivaluedHashMap modHeaders = new MultivaluedHashMap();
        for (String header : inputHeaders.keySet()) {
            modHeaders.put((Object)header, (Object)((List)inputHeaders.get((Object)header)));
        }
        modHeaders.put((Object)headerKey, Arrays.asList(headerValue));
        return modHeaders;
    }

    public static MultivaluedMap<String, String> setHeader(MultivaluedMap<String, String> inputHeaders, String headerKey, List<String> headerValue) {
        HTTPProxy.removeHeader(inputHeaders, headerKey);
        MultivaluedHashMap modHeaders = new MultivaluedHashMap();
        for (String header : inputHeaders.keySet()) {
            modHeaders.put((Object)header, (Object)((List)inputHeaders.get((Object)header)));
        }
        modHeaders.put((Object)headerKey, headerValue);
        return modHeaders;
    }

    public static Map<String, List<String>> pipeOutgoingHeaders(HttpHeaders requestHeaders, Map<String, List<String>> responseHeaders, boolean enableCORS) {
        HashMap<String, List<String>> outputHeaders = new HashMap<String, List<String>>();
        if (responseHeaders == null) {
            return outputHeaders;
        }
        for (String header : responseHeaders.keySet()) {
            if (header == null) continue;
            if (header.toLowerCase().equals("content-type")) {
                ArrayList<String> adaptedHeader = new ArrayList<String>();
                for (String value : responseHeaders.get(header)) {
                    if (value.contains("subtype=gml/")) {
                        value = value.replace("subtype=gml/", "subtype=\"gml/");
                        value = value + "\"";
                    }
                    adaptedHeader.add(value);
                }
                outputHeaders.put(header, adaptedHeader);
                continue;
            }
            String headerValue = "";
            int cnt = 0;
            for (String value : responseHeaders.get(header)) {
                if (cnt > 0) {
                    headerValue = headerValue + "; ";
                }
                headerValue = headerValue + value;
                ++cnt;
            }
            outputHeaders.put(header, Arrays.asList(headerValue));
        }
        if (enableCORS && requestHeaders != null) {
            MultivaluedMap rHeaders = requestHeaders.getRequestHeaders();
            List<String> corsAllowedOrigins = Arrays.asList("https://projects.narimo.de", "https://hengavv.com");
            ArrayList<String> corsAllowedMethods = new ArrayList<String>();
            corsAllowedMethods.add("GET");
            corsAllowedMethods.add("PUT");
            corsAllowedMethods.add("POST");
            corsAllowedMethods.add("HEAD");
            corsAllowedMethods.add("OPTIONS");
            String requestOrigin = (String)rHeaders.getFirst((Object)"origin");
            if (corsAllowedOrigins.contains(requestOrigin)) {
                outputHeaders.put("Access-Control-Allow-Origin", Arrays.asList(requestOrigin));
                outputHeaders.put("Access-Control-Allow-Methods", Arrays.asList(corsAllowedMethods.toString().substring(1, corsAllowedMethods.toString().length() - 1)));
                if (HTTPProxy.authorizationRequested(requestHeaders)) {
                    outputHeaders.put("Access-Control-Allow-Headers", Arrays.asList("authorization"));
                    outputHeaders.put("Access-Control-Allow-Credentials", Arrays.asList("true"));
                }
            }
        }
        return outputHeaders;
    }

    private static boolean authorizationRequested(HttpHeaders requestHeaders) {
        return requestHeaders.getRequestHeaders().getFirst((Object)"Authorization") != null || requestHeaders.getRequestHeaders().getFirst((Object)"Access-Control-Request-Headers") != null && ((String)requestHeaders.getRequestHeaders().getFirst((Object)"Access-Control-Request-Headers")).contains("authorization");
    }

    public static Map<String, String> getHeaders(HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        HashMap<String, String> headers = new HashMap<String, String>();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            headers.put(key.toLowerCase(), request.getHeader(key));
        }
        return headers;
    }
}

