/*
 * Decompiled with CFR 0.152.
 */
package de.narimo.commons.ws.http.async;

import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.client.AsyncInvoker;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Cookie;
import javax.xml.bind.DatatypeConverter;

public class AsyncHttpURLClient {
    private Client client = null;
    private WebTarget target = null;
    private Invocation.Builder b = null;
    private String authHeader = null;
    private Cookie[] sessionCookies = null;
    private Map<InvocationCallback<String>, Boolean> doneCallbacks = new HashMap<InvocationCallback<String>, Boolean>();
    private int threadSleepTime = 10;

    public AsyncHttpURLClient() {
        this.client = ClientBuilder.newClient();
    }

    public void setAuthorizationHeader(String user, String pass) {
        String basicAuth;
        String userpass = user + ":" + pass;
        this.authHeader = basicAuth = "Basic " + DatatypeConverter.printBase64Binary((byte[])userpass.getBytes());
    }

    public void setSessionCookies(Cookie[] cookies) {
        this.sessionCookies = cookies;
    }

    public void get(String url, Map<String, String> queryParams, InvocationCallback callback) throws Exception {
        if (queryParams != null) {
            if (!url.endsWith("?")) {
                url = url + "?";
            }
            for (String string : queryParams.keySet()) {
                url = url + "&" + URLEncoder.encode(string, "UTF-8") + "=" + URLEncoder.encode(queryParams.get(string), "UTF-8");
            }
        }
        this.target = this.client.target(url);
        this.b = this.target.request();
        System.out.println("Sending async GET to: " + url);
        if (this.sessionCookies != null) {
            String cookieString = "";
            for (Cookie c : this.sessionCookies) {
                this.b.cookie(c.getName(), c.getValue());
                cookieString = cookieString + c.getName() + "=" + c.getValue() + "; ";
            }
            System.out.println("with cookies: " + cookieString);
        }
        if (this.authHeader != null) {
            this.b.header("Authorization", (Object)this.authHeader);
        }
        System.out.println("with credentials: " + (this.authHeader != null ? "yes" : "no"));
        AsyncInvoker asyncInvoker = this.b.async();
        this.doneCallbacks.put((InvocationCallback<String>)callback, false);
        Future future = asyncInvoker.get(callback);
    }

    public Map<InvocationCallback<String>, Boolean> getCallbackMap() {
        return this.doneCallbacks;
    }

    public void setFinished(InvocationCallback callback) {
        this.doneCallbacks.put((InvocationCallback<String>)callback, true);
    }

    public boolean allCallbacksFinished() {
        for (InvocationCallback<String> cb : this.doneCallbacks.keySet()) {
            while (this.doneCallbacks.get(cb) == false) {
                try {
                    Thread.sleep(this.threadSleepTime);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return true;
    }

    public void close() {
        this.client.close();
    }
}

