/*
 * Decompiled with CFR 0.152.
 */
package de.narimo.commons.ws.http;

import de.narimo.commons.http.URLResponse;
import de.narimo.commons.ws.http.HTTPRequestParams;
import de.narimo.commons.ws.http.HttpURLClient;
import de.narimo.commons.ws.http.auth.HTTPBasicAuthorizationFactory;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;

public class HTTPRequestWrapper {
    public static URLResponse sendRequest(HTTPRequestParams params, boolean toExternal) throws Exception {
        String url = params.getUrl();
        MultivaluedMap<String, String> queryParams = params.getQueryParams();
        Map<String, String> connectionHeaders = params.getConnectionHeaders();
        HTTPBasicAuthorizationFactory authFactory = params.getAuthFactory();
        if (toExternal) {
            url = HTTPRequestWrapper.removeApikey(params.getUrl());
            queryParams = HTTPRequestWrapper.removeApikey(params.getQueryParams());
            connectionHeaders = HTTPRequestWrapper.removeAuthHeaders(params.getConnectionHeaders());
            authFactory = null;
        }
        URLResponse response = HttpURLClient.sendRequestMultivalue(url, queryParams, connectionHeaders, params.getBody(), params.getMethod(), authFactory, params.isHttps(), params.isResponseAsStream(), params.isFollowRedirects());
        return response;
    }

    private static MultivaluedMap<String, String> removeApikey(MultivaluedMap<String, String> queryParams) {
        queryParams.remove((Object)"apikey");
        return queryParams;
    }

    private static String removeApikey(String url) {
        String fixedUrl = url;
        if (url.toLowerCase().contains("apikey=")) {
            String[] urlParts = url.split("apikey=");
            String urlTail = urlParts[1];
            urlTail = urlTail.substring(urlTail.indexOf("&"));
            fixedUrl = urlParts[0] + urlTail;
        }
        return fixedUrl;
    }

    private static Map<String, String> removeAuthHeaders(Map<String, String> connectionHeaders) {
        connectionHeaders.remove("Authorization");
        connectionHeaders.remove("Cookies");
        return connectionHeaders;
    }

    public static void main(String[] args) {
    }
}

