/*
 * Decompiled with CFR 0.152.
 */
package de.narimo.commons.ws.mail;

import java.io.File;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class Mailer {
    private String host = "mail.narimo.de";
    private int port = 465;
    private String protocol = "smtp";

    public Mailer() {
    }

    public Mailer(String host, Integer port, String protocol) {
        if (host != null) {
            this.host = host;
        }
        if (port != null) {
            this.port = port;
        }
        if (protocol != null) {
            this.protocol = protocol;
        }
    }

    public void sendMail(String sender, String recipient, String subject, String msgBody, String username, String password) {
        this.sendMailWithAttachment(sender, recipient, subject, msgBody, username, password, null);
    }

    public void sendMailWithAttachment(String sender, String recipient, String subject, String msgBody, String username, String password, String optAttachmentPath) {
        Properties props = new Properties();
        props.put("mail.transport.protocol", this.protocol);
        props.put("mail.smtp.ssl.enable", "true");
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.host", this.host);
        props.put("mail.smtp.port", String.valueOf(this.port));
        props.put("mail.smtp.user", username);
        props.put("mail.smtp.password", password);
        System.out.println("Sending mail with user " + username + " and pass <suppressed>.");
        try {
            Session session = Session.getInstance((Properties)props, null);
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(sender));
            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)recipient));
            message.setSubject(subject);
            if (optAttachmentPath != null) {
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                messageBodyPart.setText(msgBody);
                MimeBodyPart attachmentPart = new MimeBodyPart();
                attachmentPart.attachFile(new File(optAttachmentPath));
                MimeMultipart multipart = new MimeMultipart();
                multipart.addBodyPart((BodyPart)messageBodyPart);
                multipart.addBodyPart((BodyPart)attachmentPart);
                message.setContent((Multipart)multipart);
            } else {
                message.setText(msgBody);
            }
            Transport transport = session.getTransport(this.protocol);
            transport.connect(this.host, this.port, username, password);
            transport.sendMessage((Message)message, message.getAllRecipients());
            transport.close();
            System.out.println("Mail sucessfully sent to " + recipient + ".");
        }
        catch (Exception e) {
            System.out.println("Send mail error. Recipient: " + recipient + ".");
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

