/*
 * Decompiled with CFR 0.152.
 */
package de.narimo.commons.imports;

import com.csvreader.CsvWriter;
import de.narimo.commons.dto.xml.qb.Kontaktdaten;
import de.narimo.commons.dto.xml.qb.Qualitaetsbericht;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class Krankenhaeuser2CSV {
    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws IOException {
        File outCSVFile = new File("G:\\narimo\\Geschaeft\\Datenprodukte\\Krankenhaeuser\\qb-processed\\qb2015_all_java_test_umbruche.csv");
        String xmlDirectory = "G:\\narimo\\Geschaeft\\Datenprodukte\\Krankenhaeuser\\qb-raw";
        System.out.println("Searching files to process in folder " + xmlDirectory + "...");
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        String start = sdf.format(new Date());
        List<Object> xmlFiles = new ArrayList();
        xmlFiles = Arrays.asList(new File(xmlDirectory).listFiles());
        System.out.println("Found " + xmlFiles.size() + " files to process.");
        char csvDelimiter = ';';
        CsvWriter w = null;
        String currentFile = null;
        int metaFiles = 0;
        int singleLocations = 0;
        int oneOfMultipleLocations = 0;
        int unprocessableLocations = 0;
        ArrayList<String> unprocessableLocationIds = new ArrayList<String>();
        FileInputStream fis = null;
        try {
            void var18_22;
            String[] header;
            w = new CsvWriter((Writer)new FileWriter(outCSVFile, false), csvDelimiter);
            String[] stringArray = header = "ID;Name;IKNr;Standortnummer;Strasse;Hausnr;PLZ;Ort;URL;Anzahl_Betten;Erstelldatum".split(String.valueOf(csvDelimiter));
            int n = stringArray.length;
            boolean bl = false;
            while (var18_22 < n) {
                String h = stringArray[var18_22];
                w.write(h);
                ++var18_22;
            }
            w.endRecord();
            w.flush();
            int cnt = 0;
            for (File file : xmlFiles) {
                if (!file.isFile() || !file.getName().endsWith(".xml")) continue;
                currentFile = file.getName();
                System.out.println("Processing file " + currentFile + ".");
                JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Qualitaetsbericht.class});
                Unmarshaller unmarshaller = jc.createUnmarshaller();
                XMLInputFactory xmlif = XMLInputFactory.newInstance();
                fis = new FileInputStream(file);
                XMLStreamReader xmler = xmlif.createXMLStreamReader(fis);
                Qualitaetsbericht qb = (Qualitaetsbericht)unmarshaller.unmarshal(xmler);
                String lastId = "";
                if (qb.getStandorte() != null) {
                    ++metaFiles;
                    continue;
                }
                String id = null;
                String name = null;
                String iknr = null;
                String standortnummer = null;
                String strasse = null;
                String hausnr = null;
                String plz = null;
                String ort = null;
                String url = null;
                String anzahlBetten = null;
                String erstelldatum = null;
                String erstellzeit = null;
                Kontaktdaten kontaktdaten = null;
                if (qb.getEinzigerStandort() != null) {
                    ++singleLocations;
                    kontaktdaten = qb.getKrankenhaus().getKontaktdaten();
                } else if (qb.getEinzigerStandort() == null && qb.getStandort() != null) {
                    ++oneOfMultipleLocations;
                    kontaktdaten = qb.getStandort().getKontaktdaten();
                } else {
                    ++unprocessableLocations;
                    unprocessableLocationIds.add(lastId);
                    continue;
                }
                iknr = kontaktdaten.getIk();
                standortnummer = kontaktdaten.getStandortNummer();
                id = iknr + "_" + standortnummer;
                name = kontaktdaten.getName().replace("\n", " ");
                strasse = kontaktdaten.getKontaktZugang().getStrasse();
                hausnr = kontaktdaten.getKontaktZugang().getHausnummer();
                plz = kontaktdaten.getKontaktZugang().getPlz();
                ort = kontaktdaten.getKontaktZugang().getOrt();
                url = kontaktdaten.getKontaktZugang().getUrl();
                anzahlBetten = qb.getAnzahlBetten();
                erstelldatum = qb.getEinleitung().getDatensatz().getDatum();
                erstellzeit = qb.getEinleitung().getDatensatz().getUhrzeit();
                w.write(id);
                w.write(name);
                w.write(iknr);
                w.write(standortnummer);
                w.write(strasse);
                w.write(hausnr);
                w.write(plz);
                w.write(ort);
                w.write(url);
                w.write(anzahlBetten);
                w.write(erstelldatum + " " + erstellzeit);
                w.endRecord();
                if (cnt % 50 == 0) {
                    w.flush();
                }
                fis.close();
                ++cnt;
            }
            w.flush();
        }
        catch (Exception e) {
            System.out.println("Error while processing file " + currentFile + ".");
            e.printStackTrace();
            w.close();
            fis.close();
        }
        String fin = sdf.format(new Date());
        System.out.println("Started operation at " + start + ".");
        System.out.println("Finished operation at " + fin + ".");
        System.out.println("Single locations: " + singleLocations + ".");
        System.out.println("Incorporated locations: " + oneOfMultipleLocations + ".");
        System.out.println("Meta location files: " + metaFiles + ".");
        System.out.println("Unprocessable locations: " + unprocessableLocations + ".");
    }
}

