/*
 * Decompiled with CFR 0.152.
 */
package de.narimo.commons;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import de.narimo.commons.dto.BBox;
import de.narimo.commons.dto.xml.ows.BoundingBox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BBoxTools {
    public static BBox toBBox(String gnGeoBox, String optDelimiter, AxisOrder axisOrder) throws Exception {
        String[] split;
        if (gnGeoBox == null) {
            return null;
        }
        if (optDelimiter == null) {
            optDelimiter = ",";
        }
        if ((split = gnGeoBox.split("\\" + optDelimiter)).length != 4) {
            throw new IllegalArgumentException("BBox must consist of four coordinates.");
        }
        BBox bbox = new BBox();
        if (axisOrder.equals((Object)AxisOrder.X_Y)) {
            bbox.setXMin(Double.valueOf(split[0]).doubleValue());
            bbox.setYMin(Double.valueOf(split[1]).doubleValue());
            bbox.setXMax(Double.valueOf(split[2]).doubleValue());
            bbox.setYMax(Double.valueOf(split[3]).doubleValue());
        } else if (axisOrder.equals((Object)AxisOrder.Y_X)) {
            bbox.setYMin(Double.valueOf(split[0]).doubleValue());
            bbox.setXMin(Double.valueOf(split[1]).doubleValue());
            bbox.setYMax(Double.valueOf(split[2]).doubleValue());
            bbox.setXMax(Double.valueOf(split[3]).doubleValue());
        } else {
            throw new Exception("Unknown axis order " + (Object)((Object)axisOrder));
        }
        return bbox;
    }

    public static BBox toBBox(BoundingBox boundingBox, AxisOrder axisOrder) throws Exception {
        if (boundingBox == null) {
            return null;
        }
        List<Double> lowerCorner = BBoxTools.cornerToCoordinateTuple(boundingBox.getLowerCorner());
        List<Double> upperCorner = BBoxTools.cornerToCoordinateTuple(boundingBox.getUpperCorner());
        BBox bbox = new BBox();
        if (axisOrder == null || axisOrder.equals((Object)AxisOrder.Y_X)) {
            bbox.setXMin(lowerCorner.get(1).doubleValue());
            bbox.setYMin(lowerCorner.get(0).doubleValue());
            bbox.setXMax(upperCorner.get(1).doubleValue());
            bbox.setYMax(upperCorner.get(0).doubleValue());
        } else if (axisOrder.equals((Object)AxisOrder.X_Y)) {
            bbox.setYMin(lowerCorner.get(1).doubleValue());
            bbox.setXMin(lowerCorner.get(0).doubleValue());
            bbox.setYMax(upperCorner.get(1).doubleValue());
            bbox.setXMax(upperCorner.get(0).doubleValue());
        } else {
            throw new Exception("Unknown axis order " + (Object)((Object)axisOrder));
        }
        return bbox;
    }

    private static List<Double> cornerToCoordinateTuple(String cornerCoordinates) {
        List<String> cornerArray = Arrays.asList(cornerCoordinates.split("\\s"));
        ArrayList<Double> corner = new ArrayList<Double>();
        for (String c : cornerArray) {
            try {
                corner.add(Double.parseDouble(c));
            }
            catch (NumberFormatException e) {}
        }
        return corner;
    }

    public static BBox[] toBBoxArray(List<String> gnGeoBoxArray, String optDelimiter, AxisOrder axisOrder) throws Exception {
        if (gnGeoBoxArray == null) {
            return null;
        }
        BBox[] bboxArray = new BBox[gnGeoBoxArray.size()];
        int i = 0;
        for (String b : gnGeoBoxArray) {
            bboxArray[i] = BBoxTools.toBBox(b, optDelimiter, axisOrder);
            ++i;
        }
        return bboxArray;
    }

    public static String bboxArrayToWKTMultipolygon(BBox[] bboxArray) {
        if (bboxArray == null) {
            return null;
        }
        String bboxWKT = "Multipolygon(";
        int i = 0;
        for (BBox bbox : bboxArray) {
            if (bbox == null) continue;
            if (i > 0) {
                bboxWKT = bboxWKT + ",";
            }
            bboxWKT = bboxWKT + "((" + bbox.getXMin() + " " + bbox.getYMax() + "," + bbox.getXMax() + " " + bbox.getYMax() + "," + bbox.getXMax() + " " + bbox.getYMin() + "," + bbox.getXMin() + " " + bbox.getYMin() + "," + bbox.getXMin() + " " + bbox.getYMax() + "))";
            ++i;
        }
        bboxWKT = bboxWKT + ")";
        return bboxWKT;
    }

    public static String bboxToWktPolygon(BBox bbox) {
        if (bbox == null) {
            bbox = new BBox();
            bbox.XMax = 180.0;
            bbox.XMin = -180.0;
            bbox.YMax = 90.0;
            bbox.YMin = -90.0;
        }
        String bboxWKT = "Multipolygon(";
        bboxWKT = bboxWKT + "((" + bbox.getXMin() + " " + bbox.getYMax() + "," + bbox.getXMax() + " " + bbox.getYMax() + "," + bbox.getXMax() + " " + bbox.getYMin() + "," + bbox.getXMin() + " " + bbox.getYMin() + "," + bbox.getXMin() + " " + bbox.getYMax() + "))";
        bboxWKT = bboxWKT + ")";
        return bboxWKT;
    }

    public static BBox wktToBBox(String wkt) {
        Geometry g;
        if (wkt == null) {
            return null;
        }
        WKTReader reader = new WKTReader();
        try {
            g = reader.read(wkt);
        }
        catch (ParseException e) {
            return null;
        }
        Envelope env = g.getEnvelopeInternal();
        BBox bbox = new BBox();
        bbox.setXMin(env.getMinX());
        bbox.setYMin(env.getMinY());
        bbox.setXMax(env.getMaxX());
        bbox.setYMax(env.getMaxY());
        return bbox;
    }

    public static String toString(BBox bbox, AxisOrder axisOrder) {
        if (axisOrder.equals((Object)AxisOrder.X_Y)) {
            return bbox.getXMin() + "," + bbox.getYMin() + "," + bbox.getXMax() + "," + bbox.getYMax();
        }
        if (axisOrder.equals((Object)AxisOrder.Y_X)) {
            return bbox.getYMin() + "," + bbox.getXMin() + "," + bbox.getYMax() + "," + bbox.getXMax();
        }
        return null;
    }

    public static double constrainToWGS84Box(double coordinate, String axis) {
        if (axis.equals("x")) {
            if (coordinate < -180.0) {
                return -180.0;
            }
            if (coordinate > 180.0) {
                return 180.0;
            }
        }
        if (axis.equals("y")) {
            if (coordinate < -90.0) {
                return -90.0;
            }
            if (coordinate > 90.0) {
                return 90.0;
            }
        }
        return coordinate;
    }

    public static void main(String[] args) {
    }

    public static enum AxisOrder {
        X_Y,
        Y_X;

    }
}

