/*
 * Decompiled with CFR 0.152.
 */
package de.narimo.geocore.ws.auth.tools;

import de.narimo.commons.UserCredentials;
import de.narimo.commons.jdbc.JDBCConnectionJNDI;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.naming.AuthenticationException;
import org.apache.commons.lang3.RandomStringUtils;

public class AuthenticationTools {
    public static String createSession(String userName, String userPass) throws Exception {
        String sessionId = null;
        JDBCConnectionJNDI jdbcAuth = null;
        try {
            jdbcAuth = new JDBCConnectionJNDI("jdbc/georepoAuthDatasource");
            System.out.println("Attempting to create session for " + userName + " | pass?=" + (userPass != null ? "yes" : "no"));
            String sql = "SELECT 1 FROM public.users where username LIKE ? and enabled=true and password LIKE sha256g(?)";
            PreparedStatement ps = jdbcAuth.prepareStatement(sql);
            ps.setString(1, userName);
            ps.setString(2, userPass);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) {
                throw new AuthenticationException("Login of user failed.");
            }
            sessionId = AuthenticationTools.createSessionId();
            String sessionSql = "INSERT INTO public.session_store (sessionid, username) VALUES(?, ?)";
            PreparedStatement ps1 = jdbcAuth.prepareStatement(sessionSql);
            ps1.setString(1, sessionId);
            ps1.setString(2, userName);
            ps1.execute();
            System.out.println("Authenticating " + userName + "... successful!");
        }
        catch (Exception e) {
            System.out.println("Authenticating " + userName + "... failed!");
            e.printStackTrace();
            throw e;
        }
        finally {
            if (jdbcAuth != null) {
                jdbcAuth.closeAll();
                jdbcAuth = null;
            }
        }
        return sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean destroySession(String sessionId, boolean remove) throws Exception {
        JDBCConnectionJNDI jdbcMeta = null;
        try {
            jdbcMeta = new JDBCConnectionJNDI("jdbc/georepoAuthDatasource");
            String sql = "UPDATE session_store SET expires=timezone('utc'::text, now()) WHERE sessionid='" + sessionId + "';";
            if (remove) {
                sql = "DELETE FROM session_store WHERE sessionid = '" + sessionId + "';";
            }
            jdbcMeta.execute(sql);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Removing session id " + sessionId + " from session store failed. Expiring session anyway.");
        }
        finally {
            jdbcMeta.closeAll();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserCredentials getAndRenewLoggedInUser(String sessionid) throws Exception {
        System.out.println("Checking provided session id " + sessionid + ".");
        if (sessionid == null) {
            return null;
        }
        JDBCConnectionJNDI jdbcMeta = null;
        ResultSet rs = null;
        int sessionLength = 20;
        try {
            jdbcMeta = new JDBCConnectionJNDI("jdbc/georepoAuthDatasource");
            String sql = "SELECT * FROM session_store WHERE sessionid='" + sessionid + "' AND expires>timezone('utc'::text, now())";
            rs = jdbcMeta.executeQuery(sql);
            if (!rs.next()) {
                UserCredentials userCredentials = null;
                return userCredentials;
            }
            UserCredentials credentials = new UserCredentials();
            credentials.setUserCredentials(rs.getString("username"), "");
            String sql2 = "UPDATE session_store SET expires=timezone('utc'::text, (now() + ((" + String.valueOf(sessionLength) + " || ' minutes'::text))::interval)) WHERE sessionid='" + sessionid + "'";
            jdbcMeta.execute(sql2);
            UserCredentials userCredentials = credentials;
            return userCredentials;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Look up for session id " + sessionid + " failed. Session id not valid.");
        }
        finally {
            if (jdbcMeta != null) {
                jdbcMeta.closeAll();
            }
        }
        return null;
    }

    private static String createSessionId() {
        return RandomStringUtils.randomAlphanumeric((int)32);
    }

    public static void main(String[] args) throws Exception {
    }
}

