/*
 * Decompiled with CFR 0.152.
 */
package de.narimo.geocore.ws.auth.filter;

import de.narimo.commons.UserCredentials;
import de.narimo.geocore.ws.auth.OverrideSecurityContext;
import de.narimo.geocore.ws.auth.tools.AuthenticationFilterTools;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

public abstract class BasicAuthenticationFilter
implements ContainerRequestFilter {
    @Context
    ServletContext ctx;
    @Context
    HttpServletRequest httprequest;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        try {
            this.filterBasic(requestContext);
        }
        catch (Exception e) {
            e.printStackTrace();
            BasicAuthenticationFilter.refuseRequest403(requestContext);
        }
    }

    void filterBasic(ContainerRequestContext requestContext) throws Exception {
        System.out.println("Checking basic auth...");
        UserCredentials credentials = null;
        String allowBasicAuth = this.ctx.getInitParameter("ALLOW_BASIC_AUTH");
        if (allowBasicAuth == null || !allowBasicAuth.equals("true")) {
            BasicAuthenticationFilter.refuseRequest403(requestContext);
        } else {
            credentials = AuthenticationFilterTools.getUserCredentials(this.httprequest);
            if (credentials != null) {
                this.authenticateBasic(requestContext, credentials);
            } else {
                System.out.println("No authentication header was set...");
                credentials = this.handleNoAuthenticationHeader(requestContext, this.httprequest);
                if (credentials == null) {
                    BasicAuthenticationFilter.refuseRequest401(requestContext);
                    return;
                }
            }
        }
        if (!this.checkCredentials(requestContext, credentials)) {
            return;
        }
        System.out.println("BasicAuthenticationFilter, authentication successful for " + credentials.getUsername() + ":password set=" + (credentials.getPassword() == null ? "no" : "yes"));
        this.prepareSecurityContext(requestContext, credentials);
    }

    private UserCredentials getDummyCredentialsForOptionsMethod() {
        return new UserCredentials("dummyOptionsUser", "dummyOptionsPassword");
    }

    void prepareSecurityContext(ContainerRequestContext requestContext, UserCredentials credentials) throws Exception {
        ArrayList<String> roles = this.getRoles();
        requestContext.setSecurityContext((SecurityContext)new OverrideSecurityContext(credentials.getUsername(), roles, this.httprequest));
    }

    boolean checkCredentials(ContainerRequestContext requestContext, UserCredentials credentials) {
        if (credentials == null) {
            BasicAuthenticationFilter.refuseRequest403(requestContext);
            return false;
        }
        if (credentials.getUsername().equals("") || credentials.getUsername() == null || credentials.getPassword() == null) {
            BasicAuthenticationFilter.refuseRequest403(requestContext);
            return false;
        }
        return true;
    }

    public void authenticateBasic(ContainerRequestContext requestContext, UserCredentials credentials) throws Exception {
        throw new UnsupportedOperationException("Invalid authentication filter base class. Use a custom filter implementation.");
    }

    public UserCredentials handleNoAuthenticationHeader(ContainerRequestContext crc, HttpServletRequest httpRequest) throws NotFoundException {
        if (crc.getMethod().equals("OPTIONS")) {
            System.out.println("OPTIONS method called. Allowing...");
            return this.getDummyCredentialsForOptionsMethod();
        }
        return null;
    }

    void init(FilterConfig filterConfig) throws ServletException {
    }

    private static void refuseRequest(ContainerRequestContext requestContext, boolean issueAuthenticationHeader) {
        try {
            if (issueAuthenticationHeader) {
                String authVal = "None";
                authVal = "Basic auth=\"Internal\"";
                requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)authVal).type("text/plain").build());
                System.out.println("Responding 401. Requiring authentication details...");
            } else {
                requestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Authentication failed. Access denied.").type("text/plain").build());
                System.out.println("Responding 403. User authentication failed.");
            }
        }
        catch (Exception e) {
            return;
        }
    }

    static void refuseRequest401(ContainerRequestContext requestContext) {
        BasicAuthenticationFilter.refuseRequest(requestContext, true);
    }

    static void refuseRequest403(ContainerRequestContext requestContext) {
        BasicAuthenticationFilter.refuseRequest(requestContext, false);
    }

    void destroy() {
    }

    public ArrayList<String> getRoles() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        return list;
    }
}

