/*
 * Decompiled with CFR 0.152.
 */
package de.narimo.geocore.ws.auth;

import de.narimo.commons.UserCredentials;
import de.narimo.commons.ws.http.auth.HTTPAuthorizationFactory;
import de.narimo.geocore.ws.auth.tools.AuthenticationTools;
import java.net.URL;
import javax.naming.AuthenticationException;
import javax.servlet.ServletContext;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Cookie;

public class SessionTokenAuth {
    public static UserCredentials authenticateSessionToken(ServletContext ctx, ContainerRequestContext requestContext, String sessionToken) throws Exception {
        UserCredentials loggedInUser = AuthenticationTools.getAndRenewLoggedInUser(sessionToken);
        if (loggedInUser == null) {
            AuthenticationException ae = new AuthenticationException("Session id not valid.");
            ae.printStackTrace();
            throw ae;
        }
        HTTPAuthorizationFactory authFactory = new HTTPAuthorizationFactory();
        String geometaUrl = ctx.getInitParameter("geometaUrlInternal");
        if (geometaUrl == null) {
            throw new IllegalStateException("Context parameter geometaUrl is not defined.");
        }
        Cookie sessionCookie = new Cookie("GSESSIONID", sessionToken, new URL(geometaUrl).getPath(), null);
        if (sessionCookie != null) {
            authFactory.setSessionCookies(new Cookie[]{sessionCookie});
        }
        requestContext.setProperty("authFactory", (Object)authFactory);
        return loggedInUser;
    }
}

