/*
 * Decompiled with CFR 0.152.
 */
package de.narimo.geocore.ws.auth.filter;

import de.narimo.commons.UserCredentials;
import de.narimo.geocore.ws.auth.filter.BasicAuthenticationFilter;
import de.narimo.geocore.ws.auth.tools.AuthenticationFilterTools;
import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Cookie;

public abstract class CookieAuthenticationFilter
extends BasicAuthenticationFilter {
    @Override
    public void filter(ContainerRequestContext requestContext) throws IOException {
        System.out.println(this.getClass().getSimpleName());
        try {
            this.filterCookie(requestContext);
        }
        catch (Exception e) {
            e.printStackTrace();
            CookieAuthenticationFilter.refuseRequest403(requestContext);
        }
    }

    void filterCookie(ContainerRequestContext requestContext) throws Exception {
        String sessionToken;
        String allowCookieAuth = this.ctx.getInitParameter("ALLOW_COOKIE_AUTH");
        if (allowCookieAuth == null || !allowCookieAuth.equals("true")) {
            this.filterBasic(requestContext);
            return;
        }
        System.out.println("Checking cookie auth...");
        Cookie sessionCookie = AuthenticationFilterTools.getSessionCookie(this.httprequest, "narimosessid");
        String string = sessionToken = sessionCookie == null ? null : sessionCookie.getValue();
        if (sessionToken == null) {
            this.filterBasic(requestContext);
            return;
        }
        UserCredentials credentials = this.authenticateJSESSIONIDToken(requestContext, sessionToken);
        if (!this.checkCredentials(requestContext, credentials)) {
            return;
        }
        System.out.println("CookieAuthenticationFilter, authentication successful for " + credentials.getUsername() + ":token from cookie set=" + (credentials.getPassword() == null ? "no" : "yes"));
        this.prepareSecurityContext(requestContext, credentials);
    }

    public UserCredentials authenticateJSESSIONIDToken(ContainerRequestContext requestContext, String sessionToken) throws Exception {
        throw new UnsupportedOperationException("Invalid authentication filter base class. Use a custom filter implementation.");
    }
}

