/*
 * Decompiled with CFR 0.152.
 */
package de.narimo.geocore.ws.auth.filter;

import de.narimo.commons.UserCredentials;
import de.narimo.commons.ws.http.auth.HTTPAuthorizationFactory;
import de.narimo.geocore.ws.auth.tools.AuthenticationFilterTools;
import java.io.IOException;
import javax.annotation.Priority;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.ext.Provider;

@Provider
@Priority(value=1000)
public class AuthenticationRegistrationFilter
implements ContainerRequestFilter {
    @Context
    private HttpServletRequest httprequest;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        System.out.println(this.getClass().getSimpleName());
        HTTPAuthorizationFactory authFactory = new HTTPAuthorizationFactory();
        try {
            UserCredentials credentials;
            Cookie sessionCookieIn = AuthenticationFilterTools.getSessionCookie(this.httprequest, "narimosessid");
            if (sessionCookieIn != null) {
                long t = System.currentTimeMillis();
                Cookie sessionCookie = new Cookie("narimosessid", sessionCookieIn.getValue(), "/geometa-server/", null);
                Cookie timeCookie = new Cookie("serverTime", String.valueOf(t));
                Cookie expiryCookie = new Cookie("sessionExpiry", String.valueOf(t));
                Cookie[] cs = new Cookie[]{sessionCookie, timeCookie, expiryCookie};
                authFactory.setSessionCookies(cs);
            }
            if ((credentials = AuthenticationFilterTools.getUserCredentials(this.httprequest)) != null) {
                authFactory.setCredentials(credentials);
            }
            requestContext.setProperty("authFactory", (Object)authFactory);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Couldn't set authentication details in " + this.getClass().getSimpleName());
        }
    }
}

