/*
 * Decompiled with CFR 0.152.
 */
package de.narimo.geocore.ws.auth.filter;

import de.narimo.commons.UserCredentials;
import de.narimo.geocore.ws.auth.JWTFactory;
import de.narimo.geocore.ws.auth.filter.CookieAuthenticationFilter;
import de.narimo.geocore.ws.auth.tools.AuthenticationFilterTools;
import java.io.IOException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.container.ContainerRequestContext;

public abstract class BearerAuthenticationFilter
extends CookieAuthenticationFilter {
    @Override
    public void filter(ContainerRequestContext requestContext) throws IOException {
        System.out.println(this.getClass().getSimpleName());
        try {
            this.filterBearer(requestContext);
        }
        catch (Exception e) {
            e.printStackTrace();
            BearerAuthenticationFilter.refuseRequest403(requestContext);
        }
    }

    void filterBearer(ContainerRequestContext requestContext) throws Exception {
        String allowBearerAuth = this.ctx.getInitParameter("ALLOW_BEARER_AUTH");
        if (allowBearerAuth == null || !allowBearerAuth.equals("true")) {
            this.filterCookie(requestContext);
            return;
        }
        System.out.println("Checking bearer auth...");
        String bearerToken = AuthenticationFilterTools.getBearerToken(this.httprequest);
        if (bearerToken == null) {
            this.filterCookie(requestContext);
            return;
        }
        JWTFactory jwtFactory = new JWTFactory(this.ctx.getInitParameter("JWT_PRIVATE_SERVER_SECRET"), this.ctx.getInitParameter("JWT_ISSUER"));
        String sessionToken = null;
        boolean isValid = false;
        isValid = jwtFactory.verifyToken(bearerToken);
        if (isValid) {
            sessionToken = jwtFactory.getAccessToken(bearerToken);
        }
        if (sessionToken == null) {
            throw new ForbiddenException("No valid session id provided with bearer token.");
        }
        UserCredentials credentials = this.authenticateJSESSIONIDToken(requestContext, sessionToken);
        if (!this.checkCredentials(requestContext, credentials)) {
            return;
        }
        System.out.println("BearerAuthenticationFilter, authentication successful for " + credentials.getUsername() + ": bearer token set=" + (credentials.getPassword() == null ? "no" : "yes"));
        this.prepareSecurityContext(requestContext, credentials);
    }
}

