/*
 * Decompiled with CFR 0.152.
 */
package de.narimo.geocore.ws.auth;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTCreationException;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;

public class JWTFactory {
    private String secret;
    private String issuer;
    private String atn;
    private static String ACCESS_TOKEN_IDENTIFIER = "atn";

    public JWTFactory(String secret, String issuer) {
        this.secret = secret;
        this.issuer = issuer;
    }

    public void setAccessToken(String authorizationToken) {
        this.atn = authorizationToken;
    }

    public String createToken(int validityMins) {
        String jwtToken = null;
        Date expirationDate = null;
        if (validityMins > 0) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(System.currentTimeMillis() + (long)(validityMins * 60 * 1000));
            expirationDate = cal.getTime();
        }
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)this.secret);
            JWTCreator.Builder b = JWT.create().withIssuer(this.issuer);
            if (expirationDate != null) {
                b.withExpiresAt(expirationDate);
            }
            if (this.atn != null) {
                b.withClaim(ACCESS_TOKEN_IDENTIFIER, this.atn);
            }
            jwtToken = b.sign(algorithm);
        }
        catch (UnsupportedEncodingException exception) {
            exception.printStackTrace();
        }
        catch (JWTCreationException exception) {
            exception.printStackTrace();
        }
        if (jwtToken == null) {
            throw new IllegalArgumentException("No token was created due to incorrect claims.");
        }
        return jwtToken;
    }

    public boolean verifyToken(String jwtToken) throws Exception {
        if (jwtToken == null) {
            return false;
        }
        Algorithm algorithm = Algorithm.HMAC256((String)this.secret);
        JWTVerifier verifier = JWT.require((Algorithm)algorithm).withIssuer(this.issuer).build();
        verifier.verify(jwtToken);
        return true;
    }

    public String getAccessToken(String jwtToken) {
        try {
            DecodedJWT jwt = JWT.decode((String)jwtToken);
            Claim accessTokenClaim = jwt.getClaim("atn");
            if (accessTokenClaim.isNull()) {
                return null;
            }
            return accessTokenClaim.asString();
        }
        catch (JWTDecodeException jWTDecodeException) {
            return null;
        }
    }

    public static void main(String[] args) {
    }
}

