/*
 * Decompiled with CFR 0.152.
 */
package de.narimo.geocore.ws.auth;

import java.security.Principal;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.SecurityContext;

public class OverrideSecurityContext
implements SecurityContext {
    String user;
    List<String> userRoles;
    HttpServletRequest request;

    public OverrideSecurityContext(String user, List<String> roles, HttpServletRequest request) {
        this.user = user;
        this.userRoles = roles;
        this.request = request;
    }

    public Principal getUserPrincipal() {
        if (this.user == null) {
            return this.request.getUserPrincipal();
        }
        return new Principal(){

            @Override
            public String getName() {
                return OverrideSecurityContext.this.user;
            }
        };
    }

    public String getAuthenticationScheme() {
        return null;
    }

    public boolean isSecure() {
        return false;
    }

    public boolean isUserInRole(String role) {
        if (this.userRoles == null) {
            return this.request.isUserInRole(role);
        }
        return this.userRoles.contains(role);
    }
}

